(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Wolfram 14.3' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       154,          7]
NotebookDataLength[   6052061,     107613]
NotebookOptionsPosition[   5962448,     106419]
NotebookOutlinePosition[   5962841,     106435]
CellTagsIndexPosition[   5962798,     106432]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
 RowBox[{"<<", "VilTeX`"}]], "Input",
 CellChangeTimes->{{3.966968271457609*^9, 3.9669682779533978`*^9}},
 CellLabel->"In[18]:=",ExpressionUUID->"8e085755-887d-4bd1-a8b8-c65b41fd5b65"],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[GridBox[{
    {
     StyleBox["\<\"\|01f680 VilTeX cargado\"\>",
      StripOnInput->False,
      LineColor->RGBColor[0, 0, 1],
      FrontFaceColor->RGBColor[0, 0, 1],
      BackFaceColor->RGBColor[0, 0, 1],
      GraphicsColor->RGBColor[0, 0, 1],
      FontSize->16,
      FontWeight->Bold,
      FontColor->RGBColor[0, 0, 1]]},
    {
     StyleBox["\<\"\:2705 Listo para usar. Versi\[OAcute]n del \
01/10/2025.\"\>",
      StripOnInput->False,
      LineColor->GrayLevel[0],
      FrontFaceColor->GrayLevel[0],
      BackFaceColor->GrayLevel[0],
      GraphicsColor->GrayLevel[0],
      FontWeight->Bold,
      FontColor->GrayLevel[0]]}
   },
   DefaultBaseStyle->"Column",
   GridBoxAlignment->{"Columns" -> {{Left}}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Column"]], "Print",
 CellChangeTimes->{3.9669682799375896`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"d7870e64-860f-4dd6-b3ab-bcb0468765fd"],

Cell[BoxData["\<\"Mostrando editores ya detectados...\"\>"], "Print",
 CellChangeTimes->{3.9669683052359133`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"26d08116-aae8-4451-ac1c-c2e6cc783b5e"],

Cell[BoxData["\<\"=== EDITORES LaTeX DETECTADOS ===\"\>"], "Print",
 CellChangeTimes->{3.966968305236465*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"4495f0f0-0d3e-47ca-b42e-ed39bc082eda"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXShop\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"TeXShop\"\>"}],
  SequenceForm["\[Checkmark] ", "TeXShop", " \[RightArrow] ", "TeXShop"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305236766*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"4b964200-9182-44b9-be9b-cf9e07010292"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"texstudio-4.8.8-osx-m1\"\>"}],
  SequenceForm[
  "\[Checkmark] ", "TeXstudio", " \[RightArrow] ", "texstudio-4.8.8-osx-m1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237047*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"bf1d3555-c82d-42f5-bf37-8a4ed29eaf5a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"Texifier\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"Texifier\"\>"}],
  SequenceForm["\[Checkmark] ", "Texifier", " \[RightArrow] ", "Texifier"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237317*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"2c0886ca-748e-4997-b812-5bdbb7a1082b"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\[Checkmark] \"\>", "\[InvisibleSpace]", "\<\"LaTeXiT\"\>", 
   "\[InvisibleSpace]", "\<\" \[RightArrow] \"\>", 
   "\[InvisibleSpace]", "\<\"LaTeXiT\"\>"}],
  SequenceForm["\[Checkmark] ", "LaTeXiT", " \[RightArrow] ", "LaTeXiT"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966968305237576*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[18]:=",ExpressionUUID->"72247b84-9985-45df-aea2-33f6167cbd8c"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["4. ExportToTikZ", "Subtitle",
 CellChangeTimes->{{3.964711967446312*^9, 3.9647120331966953`*^9}, {
   3.965828746741377*^9, 3.965828772379876*^9}, {3.966422117997758*^9, 
   3.966422160573628*^9}, {3.9664222257197533`*^9, 3.966422232684371*^9}, {
   3.966430546956641*^9, 3.96643054737173*^9}, 3.966430633856382*^9, {
   3.966527044006247*^9, 3.9665270485002527`*^9}, {3.9672190908011293`*^9, 
   3.96721909151567*^9}},
 Background->RGBColor[
  0.4, 0.6, 1, 0.33],ExpressionUUID->"6b0a88b8-7d04-467f-a239-3cc714b54b98"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"?", "ExportToTikZ"}]], "Input",
 CellChangeTimes->{3.966529117458703*^9},
 CellLabel->
  "In[417]:=",ExpressionUUID->"895fc70b-be79-4830-a9a7-09b61a0b608e"],

Cell[BoxData[
 InterpretationBox[
  StyleBox[
   FrameBox[
    DynamicModuleBox[{System`InformationDump`open$$ = False, 
     System`InformationDump`mouseOver$$ = False}, 
     PaneSelectorBox[{True->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False,
             BaseStyle -> None],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportToTikZ[plot, filename, grid, styles, ejes, \
texto, xmin, xmax, ymin, ymax] convierte un gr\[AAcute]fico de Mathematica a \
c\[OAcute]digo TikZ/LaTeX y lo exporta como archivo .tex.\\n\\nPAR\
\[CapitalAAcute]METROS:\\n\\nplot: Gr\[AAcute]fico v\[AAcute]lido de \
Mathematica. Acepta:\\n  - Graphics (objetos gr\[AAcute]ficos puros)\\n  - \
Plot, ListPlot, DiscretePlot, ParametricPlot, PolarPlot\\n  - Show (combinaci\
\[OAcute]n de gr\[AAcute]ficos)\\n\\nfilename: String con el nombre del \
archivo de salida.\\n  - DEBE incluir extensi\[OAcute]n .tex\\n  - Ejemplo: \
\\\"migr\[AAcute]fico.tex\\\"\\n\\ngrid: Booleano (opcional, por defecto \
True).\\n  - True: Muestra rejilla mayor en el gr\[AAcute]fico\\n  - False: \
Sin rejilla\\n\\nstyles: Especificaci\[OAcute]n de estilos (opcional, por \
defecto {}).\\n  Formatos acepatados:\\n  - String \[UAcute]nico: \\\"red\\\" \
o \\\"dashed\\\"\\n  - Par: {\\\"dashed\\\", \\\"blue\\\"} o {\\\"blue\\\", \
\\\"dashed\\\"}\\n  - Lista de colores/estilos: {\\\"red\\\", \\\"blue\\\"} o \
{\\\"solid\\\", \\\"dashed\\\"}\\n  - Matriz: {{\\\"solid\\\", \\\"red\\\"}, \
{\\\"dashed\\\", \\\"blue\\\"}}\\n  \\n  Colores v\[AAcute]lidos: red, blue, \
green, orange, purple, black, brown, pink, gray, cyan, magenta, yellow, lime, \
olive, teal\\n  \\n  Estilos v\[AAcute]lidos: solid, dashed, dotted, \
dashdotted, thick\\n\\nejes: Booleano (opcional, por defecto True).\\n  - \
True: Muestra ejes centrados (axis lines=center)\\n  - False: Sin ejes (axis \
lines=none)\\n\\ntexto: Anotaciones de texto (opcional, por defecto {}).\\n  \
Formatos aceptados:\\n  - {} (vac\[IAcute]o)\\n  - {\\\"texto\\\", {x, y}} \
(una sola anotaci\[OAcute]n)\\n  - {{\\\"texto1\\\", {x1, y1}}, {\\\"texto2\\\
\", {x2, y2}}, ...} (m\[UAcute]ltiples anotaciones)\\n  \\n  NOTA: La funci\
\[OAcute]n extrae autom\[AAcute]ticamente textos existentes en el \
gr\[AAcute]fico\\n\\nxmin, xmax, ymin, ymax: L\[IAcute]mites de los ejes \
(opcionales, por defecto Automatic).\\n  - Automatic: Calcula \
autom\[AAcute]ticamente basado en los datos\\n  - N\[UAcute]mero \
v\[AAcute]lido: Especifica l\[IAcute]mite manual\\n  - xmin debe ser menor \
que xmax\\n  - ymin debe ser menor que ymax\\n\\nRETORNA: Ruta completa del \
archivo exportado.\\n\\nFUNCIONALIDADES ESPECIALES:\\n- Extrae \
autom\[AAcute]ticamente textos del gr\[AAcute]fico original\\n- Ajusta posici\
\[OAcute]n de etiquetas para evitar solapamiento con puntos\\n- Detecta \
expresiones matem\[AAcute]ticas y las formatea correctamente\\n- Aplica \
escalado autom\[AAcute]tico para valores grandes (>1000)\\n- Maneja \
m\[UAcute]ltiples tipos de primitivas gr\[AAcute]ficas\\n- Crea carpeta de \
descarga autom\[AAcute]ticamente\\n- Genera documento LaTeX completo y \
compilable\\n\\nEJEMPLOS:\\nExportToTikZ[Plot[Sin[x], {x, 0, 2\[Pi]}], \
\\\"seno.tex\\\"]\\nExportToTikZ[plot, \\\"gr\[AAcute]fico.tex\\\", True, \
\\\"red\\\", True, {}, -5, 5, -2, 2]\\nExportToTikZ[plot, \\\"styled.tex\\\", \
False, {{\\\"dashed\\\", \\\"blue\\\"}, {\\\"solid\\\", \\\"red\\\"}}]\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          PaneBox[
           TagBox[GridBox[{
              {
               StyleBox[
                TagBox[
                 TooltipBox[
                  StyleBox["\<\" Definitions\"\>", "InformationRowLabel",
                   StripOnInput->False],
                  "\"Definitions\"",
                  TooltipStyle->"TextStyling"],
                 Annotation[#, "Definitions", "Tooltip"]& ], "DialogStyle",
                StripOnInput->False]},
              {
               TemplateBox[{"\"\[ThinSpace]\"", 
                 GridBox[{{
                    RowBox[{
                    RowBox[{"ExportToTikZ", "[", 
                    
                    RowBox[{
                    "VilTeX`Private`plot_", ",", "VilTeX`Private`filename_", 
                    ",", 
                    RowBox[{"VilTeX`Private`grid_", ":", "True"}], ",", 
                    RowBox[{"VilTeX`Private`styles_", ":", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`ejes_", ":", "True"}], ",", 
                    RowBox[{"VilTeX`Private`texto_", ":", 
                    RowBox[{"{", "}"}]}], ",", 
                    RowBox[{"VilTeX`Private`xmin_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`xmax_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`ymin_", ":", "Automatic"}], ",", 
                    RowBox[{"VilTeX`Private`ymax_", ":", "Automatic"}]}], 
                    "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`data", ",", 
                    "VilTeX`Private`tikzCode", ",", 
                    "VilTeX`Private`fullDocument", ",", 
                    "VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`folderName", ",", 
                    "VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`plotRange", ",", 
                    "VilTeX`Private`xminFinal", ",", 
                    "VilTeX`Private`xmaxFinal", ",", 
                    "VilTeX`Private`yminFinal", ",", 
                    "VilTeX`Private`ymaxFinal", ",", 
                    "VilTeX`Private`formatNumber", ",", 
                    "VilTeX`Private`validNumber", ",", 
                    "VilTeX`Private`xScale", ",", "VilTeX`Private`yScale", 
                    ",", "VilTeX`Private`xLabel", ",", 
                    "VilTeX`Private`yLabel", ",", "VilTeX`Private`allPoints", 
                    ",", "VilTeX`Private`xRange", ",", 
                    "VilTeX`Private`yRange", ",", "VilTeX`Private`plotStyles",
                     ",", "VilTeX`Private`processedStyles", ",", 
                    "VilTeX`Private`numOriginalFunctions", ",", 
                    "VilTeX`Private`textAnnotations", ",", 
                    "VilTeX`Private`extractedTexts"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Clear", "[", 
                    
                    RowBox[{"VilTeX`Private`Finite", ",", 
                    "VilTeX`Private`isValidColor", ",", 
                    "VilTeX`Private`isValidStyle", ",", 
                    "VilTeX`Private`isValidColorLocal", ",", 
                    "VilTeX`Private`isValidStyleLocal", ",", 
                    "VilTeX`Private`adjustLabelPosition", ",", 
                    "VilTeX`Private`formatMathText", ",", 
                    "VilTeX`Private`escapeLaTeXText", ",", 
                    "VilTeX`Private`extractTextFromStyle", ",", 
                    "VilTeX`Private`SymbolQ"}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`plot", ",", "_Graphics"}], 
                    "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{
                    RowBox[{"Head", "[", "VilTeX`Private`plot", "]"}], ",", 
                    
                    RowBox[{"Plot", "|", "ListPlot", "|", "DiscretePlot", "|",
                     "ParametricPlot", "|", "PolarPlot"}]}], "]"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`plot", ",", "_Show"}], "]"}]}]}], 
                    ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El primer argumento debe ser un gr\[AAcute]fico \
v\[AAcute]lido (Plot, Graphics, ListPlot, DiscretePlot, ParametricPlot, \
PolarPlot, o Show).\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`filename", 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El segundo argumento debe ser un string con el \
nombre del archivo.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`filename", ",", "\".tex\""}], 
                    "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El nombre del archivo debe tener extensi\
\[OAcute]n .tex\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"BooleanQ", "[", "VilTeX`Private`grid", "]"}]}], 
                    ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El tercer argumento (grid) debe ser True o \
False.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"BooleanQ", "[", "VilTeX`Private`ejes", "]"}]}], 
                    ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: El par\[AAcute]metro 'ejes' debe ser True o \
False.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "=!=", "Automatic"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", "VilTeX`Private`xmin", "]"}]}], 
                    "||", 
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`Finite", "[", 
                    "VilTeX`Private`xmin", "]"}]}]}], ")"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: xmin debe ser un n\[UAcute]mero v\[AAcute]lido \
o Automatic.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "=!=", "Automatic"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", "VilTeX`Private`xmax", "]"}]}], 
                    "||", 
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`Finite", "[", 
                    "VilTeX`Private`xmax", "]"}]}]}], ")"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: xmax debe ser un n\[UAcute]mero v\[AAcute]lido \
o Automatic.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "=!=", "Automatic"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", "VilTeX`Private`ymin", "]"}]}], 
                    "||", 
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`Finite", "[", 
                    "VilTeX`Private`ymin", "]"}]}]}], ")"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: ymin debe ser un n\[UAcute]mero v\[AAcute]lido \
o Automatic.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "=!=", "Automatic"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"NumericQ", "[", "VilTeX`Private`ymax", "]"}]}], 
                    "||", 
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`Finite", "[", 
                    "VilTeX`Private`ymax", "]"}]}]}], ")"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: ymax debe ser un n\[UAcute]mero v\[AAcute]lido \
o Automatic.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "=!=", "Automatic"}], "&&", 
                    RowBox[{"VilTeX`Private`xmax", "=!=", "Automatic"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`xmin", "\[GreaterEqual]", 
                    "VilTeX`Private`xmax"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: xmin debe ser menor que xmax.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "=!=", "Automatic"}], "&&", 
                    RowBox[{"VilTeX`Private`ymax", "=!=", "Automatic"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`ymin", "\[GreaterEqual]", 
                    "VilTeX`Private`ymax"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"Print", "[", 
                    "\"Error: ymin debe ser menor que ymax.\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`textoValid", "=", "True"}], ",", 
                    RowBox[{"VilTeX`Private`textoError", "=", "\"\""}]}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`texto", "]"}], 
                    "\[Equal]", "0"}], ",", 
                    RowBox[{"VilTeX`Private`textoValid", "=", "True"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`texto", "]"}], 
                    "\[Equal]", "2"}], "&&", 
                    RowBox[{"StringQ", "[", 
                    
                    RowBox[{"VilTeX`Private`texto", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`texto", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"VilTeX`Private`texto", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}], "\[Equal]", "2"}], 
                    "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`texto", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], ",", "NumericQ"}], 
                    "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`textoValid", "=", "True"}], ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`texto", "]"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`texto", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "#1", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "2"}], 
                    "&&", 
                    RowBox[{"StringQ", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], "\[Equal]", "2"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], ",", "NumericQ"}], "]"}]}], 
                    "&"}]}], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`textoValid", "=", "True"}], ",", 
                    "True", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`textoValid", "=", "False"}], ";", 
                    
                    
                    RowBox[{"VilTeX`Private`textoError", "=", 
                    "\"El par\[AAcute]metro 'texto' debe tener uno de estos \
formatos:\\n  - {} (vac\[IAcute]o)\\n  - {\\\"texto\\\", {x, y}}\\n  - \
{{\\\"texto1\\\", {x1, y1}}, {\\\"texto2\\\", {x2, y2}}, ...}\""}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`textoValid"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Error: \"", "<>", 
                    "VilTeX`Private`textoError"}], "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validationResult", "=", "True"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`errorMsg", "=", "\"\""}]}], "}"}],
                     ",", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`isValidColor", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`x", "]"}], "&&", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"\"red\"", ",", "\"blue\"", ",", "\"green\"", ",",
                     "\"orange\"", ",", "\"purple\"", ",", "\"black\"", ",", 
                    "\"brown\"", ",", "\"pink\"", ",", "\"gray\"", ",", 
                    "\"cyan\"", ",", "\"magenta\"", ",", "\"yellow\"", ",", 
                    "\"lime\"", ",", "\"olive\"", ",", "\"teal\""}], "}"}], 
                    ",", "VilTeX`Private`x"}], "]"}]}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`isValidStyle", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`x", "]"}], "&&", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"\"solid\"", ",", "\"dashed\"", ",", "\"dotted\"",
                     ",", "\"dashdotted\"", ",", "\"thick\""}], "}"}], ",", 
                    "VilTeX`Private`x"}], "]"}]}]}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`styles", "]"}], 
                    "\[Equal]", "0"}], ",", 
                    RowBox[{"VilTeX`Private`validationResult", "=", "True"}], 
                    ",", 
                    RowBox[{"StringQ", "[", "VilTeX`Private`styles", "]"}], 
                    ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`isValidColor", "[", 
                    "VilTeX`Private`styles", "]"}]}], "&&", 
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`isValidStyle", "[", 
                    "VilTeX`Private`styles", "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validationResult", "=", "False"}],
                     ";", 
                    RowBox[{"VilTeX`Private`errorMsg", "=", 
                    
                    RowBox[{"\"String '\"", "<>", "VilTeX`Private`styles", 
                    "<>", "\"' no es un color o estilo v\[AAcute]lido.\""}]}],
                     ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`styles", "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`styles", "]"}], 
                    "\[Equal]", "2"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`styles", ",", "StringQ"}], "]"}], 
                    "&&", 
                    RowBox[{"!", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`styles", ",", "ListQ"}], 
                    "]"}]}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`isValidStyle", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{"VilTeX`Private`isValidColor", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}]}], ")"}]}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`isValidColor", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{"VilTeX`Private`isValidStyle", "[", 
                    
                    RowBox[{"VilTeX`Private`styles", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}]}], ")"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validationResult", "=", "False"}],
                     ";", 
                    RowBox[{"VilTeX`Private`errorMsg", "=", 
                    RowBox[{"\"El par \"", "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`styles", "]"}], 
                    "<>", "\" debe contener un estilo v\[AAcute]lido y un \
color v\[AAcute]lido.\""}]}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`styles", "]"}], 
                    "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`styles", ",", "StringQ"}], "]"}], 
                    "&&", 
                    RowBox[{"!", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`styles", ",", "ListQ"}], 
                    "]"}]}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`invalidItems", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`invalidItems", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`styles", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"VilTeX`Private`isValidColor", "[", "#1", "]"}]}],
                     "&&", 
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`isValidStyle", "[", "#1", 
                    "]"}]}]}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`invalidItems", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validationResult", "=", "False"}],
                     ";", 
                    RowBox[{"VilTeX`Private`errorMsg", "=", 
                    
                    RowBox[{
                    "\"Los siguientes elementos no son v\[AAcute]lidos: \"", 
                    "<>", 
                    RowBox[{"ToString", "[", "VilTeX`Private`invalidItems", 
                    "]"}]}]}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`styles", "]"}], 
                    "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`styles", ",", "ListQ"}], "]"}], 
                    "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`styles", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "2"}], 
                    "&"}]}], "]"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`invalidPairs", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`invalidPairs", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`styles", ",", 
                    RowBox[{
                    RowBox[{"!", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "StringQ"}], "]"}], "&&", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`isValidStyle", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{"VilTeX`Private`isValidColor", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`isValidColor", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{"VilTeX`Private`isValidStyle", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}]}], ")"}]}], ")"}]}], 
                    ")"}]}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`invalidPairs", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validationResult", "=", "False"}],
                     ";", 
                    RowBox[{"VilTeX`Private`errorMsg", "=", 
                    
                    RowBox[{
                    "\"Los siguientes pares no son v\[AAcute]lidos: \"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`invalidPairs", 
                    "]"}]}]}], ";"}]}], "]"}], ";"}]}], "]"}], ",", "True", 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`validationResult", "=", "False"}],
                     ";", 
                    RowBox[{"VilTeX`Private`errorMsg", "=", 
                    RowBox[{"\"Formato de estilos no reconocido: \"", "<>", 
                    
                    RowBox[{"ToString", "[", "VilTeX`Private`styles", 
                    "]"}]}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", "VilTeX`Private`validationResult"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{"\"Error en estilos: \"", "<>", 
                    "VilTeX`Private`errorMsg"}], "]"}], ";", 
                    
                    RowBox[{"Print", "[", "\"Formatos v\[AAcute]lidos:\"", 
                    "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"  - String \[UAcute]nico: \\\"red\\\" o \\\"dashed\\\"\
\"", "]"}], ";", 
                    RowBox[{
                    "Print", "[", 
                    "\"  - Par: {\\\"dashed\\\", \\\"blue\\\"} o \
{\\\"blue\\\", \\\"dashed\\\"}\"", "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"  - Lista de colores/estilos: {\\\"red\\\", \\\"blue\\\
\"} o {\\\"black\\\"}\"", "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"  - Lista de estilos: {\\\"solid\\\", \\\"dashed\\\", \
\\\"dotted\\\"}\"", "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"  - Matriz: {{\\\"solid\\\", \\\"red\\\"}, {\\\"dashed\
\\\", \\\"blue\\\"}}\"", "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"Colores v\[AAcute]lidos: red, blue, green, orange, \
purple, black, brown, pink, gray, cyan, magenta, yellow, lime, olive, teal\"",
                     "]"}], ";", 
                    
                    RowBox[{"Print", "[", 
                    "\"Estilos v\[AAcute]lidos: solid, dashed, dotted, \
dashdotted, thick\"", "]"}], ";", 
                    RowBox[{"Return", "[", "$Failed", "]"}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`isValidColorLocal", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`x", "]"}], "&&", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"\"red\"", ",", "\"blue\"", ",", "\"green\"", ",",
                     "\"orange\"", ",", "\"purple\"", ",", "\"black\"", ",", 
                    "\"brown\"", ",", "\"pink\"", ",", "\"gray\"", ",", 
                    "\"cyan\"", ",", "\"magenta\"", ",", "\"yellow\"", ",", 
                    "\"lime\"", ",", "\"olive\"", ",", "\"teal\""}], "}"}], 
                    ",", "VilTeX`Private`x"}], "]"}]}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`isValidStyleLocal", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`x", "]"}], "&&", 
                    RowBox[{"MemberQ", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"\"solid\"", ",", "\"dashed\"", ",", "\"dotted\"",
                     ",", "\"dashdotted\"", ",", "\"thick\""}], "}"}], ",", 
                    "VilTeX`Private`x"}], "]"}]}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`result", ",", 
                    "VilTeX`Private`num"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`num", "=", 
                    RowBox[{"N", "[", "VilTeX`Private`x", "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], "<", 
                    FractionBox["1", 
                    SuperscriptBox["10", "10"]]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", "\"0\""}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], ">", 
                    SuperscriptBox["10", "8"]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", "1"}], "]"}], ",", 
                    "InputForm"}], "]"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`num", "]"}], ">", 
                    "1000"}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", "0.01`"}], "]"}], ",", 
                    "InputForm"}], "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{
                    RowBox[{"Round", "[", 
                    RowBox[{"VilTeX`Private`num", ",", 
                    FractionBox["1", 
                    SuperscriptBox["10", "6"]]}], "]"}], ",", "InputForm"}], 
                    "]"}]}]}], "]"}]}], "]"}]}], "]"}], ";"}], ",", 
                    RowBox[{"VilTeX`Private`result", "=", "\"0\""}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`result", "]"}], 
                    ",", "VilTeX`Private`result", ",", 
                    RowBox[{"ToString", "[", "VilTeX`Private`result", "]"}]}],
                     "]"}]}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`x_", "]"}], ":=", 
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`x", "]"}], "&&", 
                    
                    RowBox[{"!", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`x", ",", "_Complex"}], "]"}]}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`x", "]"}], "<", 
                    SuperscriptBox["10", "10"]}]}]}], ";", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`adjustLabelPosition", "[", 
                    
                    RowBox[{"VilTeX`Private`textPos_", ",", 
                    "VilTeX`Private`allPointPositions_", ",", 
                    RowBox[{"VilTeX`Private`offset_", ":", "0.15`"}]}], "]"}],
                     ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`adjustedPos", "=", 
                    "VilTeX`Private`textPos"}], ",", 
                    "VilTeX`Private`minDistance", ",", 
                    "VilTeX`Private`nearestPoint", ",", "VilTeX`Private`dx", 
                    ",", "VilTeX`Private`dy", ",", 
                    "VilTeX`Private`distance"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`allPointPositions",
                     "]"}], ">", "0"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`minDistance", "=", 
                    "\[Infinity]"}], ";", 
                    RowBox[{"VilTeX`Private`nearestPoint", "=", 
                    RowBox[{"{", 
                    RowBox[{"0", ",", "0"}], "}"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`distance", "=", 
                    RowBox[{"EuclideanDistance", "[", 
                    RowBox[{"VilTeX`Private`textPos", ",", 
                    
                    RowBox[{"VilTeX`Private`allPointPositions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`distance", "<", 
                    "VilTeX`Private`minDistance"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`minDistance", "=", 
                    "VilTeX`Private`distance"}], ";", 
                    RowBox[{"VilTeX`Private`nearestPoint", "=", 
                    
                    RowBox[{"VilTeX`Private`allPointPositions", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";"}]}], "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`allPointPositions",
                     "]"}]}], "}"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`minDistance", "<", 
                    "VilTeX`Private`offset"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`dx", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`textPos", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "-", 
                    
                    RowBox[{"VilTeX`Private`nearestPoint", 
                    "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}]}]}], ";", 
                    RowBox[{"VilTeX`Private`dy", "=", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`textPos", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "-", 
                    
                    RowBox[{"VilTeX`Private`nearestPoint", 
                    "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`dx", "]"}], "<", 
                    "0.01`"}], "&&", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`dy", "]"}], "<", 
                    "0.01`"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`adjustedPos", "=", 
                    RowBox[{"VilTeX`Private`nearestPoint", "+", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`offset", ",", 
                    "VilTeX`Private`offset"}], "}"}]}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`norm", "=", 
                    SqrtBox[
                    RowBox[{
                    SuperscriptBox["VilTeX`Private`dx", "2"], "+", 
                    SuperscriptBox["VilTeX`Private`dy", "2"]}]]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`norm", ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`adjustedPos", "=", 
                    RowBox[{"VilTeX`Private`nearestPoint", "+", 
                    FractionBox[
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`dx", ",", "VilTeX`Private`dy"}], 
                    "}"}], " ", "VilTeX`Private`offset"}], 
                    "VilTeX`Private`norm"]}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`adjustedPos", "=", 
                    RowBox[{"VilTeX`Private`nearestPoint", "+", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`offset", ",", 
                    "VilTeX`Private`offset"}], "}"}]}]}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ";", "VilTeX`Private`adjustedPos"}]}], "]"}]}], 
                    ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`formatMathText", "[", 
                    "VilTeX`Private`text_String", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`result", "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`text", ",", 
                    
                    RowBox[{"RegularExpression", "[", "\"[=+\\\\-*/()^_]\"", 
                    "]"}]}], "]"}], "||", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`text", ",", 
                    
                    RowBox[{"RegularExpression", "[", 
                    "\"\\\\b[fghpqrstuvwxyz]\\\\s*\\\\(\"", "]"}]}], "]"}], 
                    "||", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`text", ",", 
                    
                    RowBox[{"RegularExpression", "[", "\"\\\\^\\\\d\"", 
                    "]"}]}], "]"}], "||", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`text", ",", 
                    
                    RowBox[{"RegularExpression", "[", "\"[xyz]\\\\^\"", 
                    "]"}]}], "]"}], "||", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`text", ",", 
                    
                    RowBox[{"RegularExpression", "[", 
                    "\"\\\\b(sin|cos|tan|log|ln|exp)\\\\b\"", "]"}]}], 
                    "]"}]}], ",", 
                    
                    RowBox[{"\"$\"", "<>", "VilTeX`Private`text", "<>", 
                    "\"$\""}], ",", 
                    
                    RowBox[{"VilTeX`Private`escapeLaTeXText", "[", 
                    "VilTeX`Private`text", "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`escapeLaTeXText", "[", 
                    "VilTeX`Private`text_String", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`result", "}"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`result", "=", 
                    "VilTeX`Private`text"}], ";", 
                    RowBox[{"VilTeX`Private`result", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`result", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"\"\\\\\"", "\[Rule]", 
                    "\"\\\\textbackslash{}\""}], ",", 
                    RowBox[{"\"{\"", "\[Rule]", "\"\\\\{\""}], ",", 
                    RowBox[{"\"}\"", "\[Rule]", "\"\\\\}\""}], ",", 
                    RowBox[{"\"$\"", "\[Rule]", "\"\\\\$\""}], ",", 
                    RowBox[{"\"&\"", "\[Rule]", "\"\\\\&\""}], ",", 
                    RowBox[{"\"%\"", "\[Rule]", "\"\\\\%\""}], ",", 
                    RowBox[{"\"#\"", "\[Rule]", "\"\\\\#\""}], ",", 
                    RowBox[{"\"^\"", "\[Rule]", "\"\\\\textasciicircum{}\""}],
                     ",", 
                    RowBox[{"\"_\"", "\[Rule]", "\"\\\\_\""}], ",", 
                    
                    RowBox[{"\"~\"", "\[Rule]", 
                    "\"\\\\textasciitilde{}\""}]}], "}"}]}], "]"}]}], ";", 
                    "VilTeX`Private`result"}]}], "]"}]}], ";", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`extractTextFromStyle", "[", 
                    "VilTeX`Private`styleObj_", "]"}], ":=", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`textContent", ",", 
                    "VilTeX`Private`rawText"}], "}"}], ",", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`styleObj", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{"VilTeX`Private`text_", ",", "___"}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`rawText", "=", 
                    
                    RowBox[{"VilTeX`Private`styleObj", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`textContent", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`rawText", "]"}], 
                    ",", "VilTeX`Private`rawText", ",", 
                    RowBox[{"VilTeX`Private`SymbolQ", "[", 
                    "VilTeX`Private`rawText", "]"}], ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`rawText", ",", "InputForm"}], 
                    "]"}], ",", "True", ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`rawText", ",", "InputForm"}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringStartsQ", "[", 
                    RowBox[{"VilTeX`Private`textContent", ",", "\"\\\"\""}], 
                    "]"}], "&&", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`textContent", ",", "\"\\\"\""}], 
                    "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`textContent", "=", 
                    RowBox[{"StringTake", "[", 
                    RowBox[{"VilTeX`Private`textContent", ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{"-", "2"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`formatMathText", "[", 
                    "VilTeX`Private`textContent", "]"}]}], ",", 
                    RowBox[{"StringQ", "[", "VilTeX`Private`styleObj", "]"}], 
                    ",", 
                    
                    RowBox[{"VilTeX`Private`formatMathText", "[", 
                    "VilTeX`Private`styleObj", "]"}], ",", 
                    
                    RowBox[{"VilTeX`Private`SymbolQ", "[", 
                    "VilTeX`Private`styleObj", "]"}], ",", 
                    RowBox[{"VilTeX`Private`formatMathText", "[", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`styleObj", ",", "InputForm"}], 
                    "]"}], "]"}], ",", "True", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`textContent", "=", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`styleObj", ",", "InputForm"}], 
                    "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringStartsQ", "[", 
                    RowBox[{"VilTeX`Private`textContent", ",", "\"\\\"\""}], 
                    "]"}], "&&", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`textContent", ",", "\"\\\"\""}], 
                    "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`textContent", "=", 
                    RowBox[{"StringTake", "[", 
                    RowBox[{"VilTeX`Private`textContent", ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{"-", "2"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`formatMathText", "[", 
                    "VilTeX`Private`textContent", "]"}]}]}], "]"}]}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`extractedTexts", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`allTexts", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allTexts", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`plot", ",", 
                    RowBox[{
                    RowBox[{"Text", "[", 
                    
                    RowBox[{"VilTeX`Private`content_", ",", 
                    "VilTeX`Private`pos_", ",", "___"}], "]"}], 
                    "\[RuleDelayed]", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`content", ",", 
                    "VilTeX`Private`pos"}], "}"}]}], ",", "\[Infinity]"}], 
                    "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`textContent", ",", 
                    "VilTeX`Private`position", ",", 
                    "VilTeX`Private`cleanText", ",", 
                    "VilTeX`Private`stringContent", ",", 
                    "VilTeX`Private`step1", ",", "VilTeX`Private`step2", ",", 
                    "VilTeX`Private`step3"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`textContent", ",", 
                    "VilTeX`Private`position"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`allTexts", "\[LeftDoubleBracket]",
                     "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`stringContent", "=", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`textContent", 
                    "]"}], ",", "VilTeX`Private`textContent", ",", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`textContent", ",", 
                    RowBox[{"Style", "[", 
                    RowBox[{"VilTeX`Private`text_", ",", "___"}], "]"}]}], 
                    "]"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`innerText", "=", 
                    
                    RowBox[{"VilTeX`Private`textContent", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringQ", "[", "VilTeX`Private`innerText", "]"}],
                     ",", "VilTeX`Private`innerText", ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`innerText", ",", "InputForm"}], 
                    "]"}]}], "]"}]}], "]"}], ",", "True", ",", 
                    RowBox[{"ToString", "[", 
                    RowBox[{"VilTeX`Private`textContent", ",", "InputForm"}], 
                    "]"}]}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`stringContent", 
                    "]"}], "&&", 
                    RowBox[{"StringStartsQ", "[", 
                    RowBox[{"VilTeX`Private`stringContent", ",", "\"\\\"\""}],
                     "]"}], "&&", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`stringContent", ",", "\"\\\"\""}],
                     "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`stringContent", "=", 
                    RowBox[{"StringTake", "[", 
                    RowBox[{"VilTeX`Private`stringContent", ",", 
                    RowBox[{"{", 
                    RowBox[{"2", ",", 
                    RowBox[{"-", "2"}]}], "}"}]}], "]"}]}], ";"}]}], "]"}], 
                    ";", 
                    
                    RowBox[{"VilTeX`Private`step1", "=", 
                    "VilTeX`Private`stringContent"}], ";", 
                    RowBox[{"VilTeX`Private`step2", "=", 
                    RowBox[{"StringReplace", "[", 
                    RowBox[{"VilTeX`Private`step1", ",", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"\"\\\\[Pi]\"", "\[Rule]", "\"\\\\pi\""}], ",", 
                    RowBox[{"\"\[Pi]\"", "\[Rule]", "\"\\\\pi\""}], ",", 
                    RowBox[{"\"\\\\[Alpha]\"", "\[Rule]", "\"\\\\alpha\""}], 
                    ",", 
                    RowBox[{"\"\[Alpha]\"", "\[Rule]", "\"\\\\alpha\""}], ",", 
                    RowBox[{"\"\\\\[Beta]\"", "\[Rule]", "\"\\\\beta\""}], 
                    ",", 
                    RowBox[{"\"\[Beta]\"", "\[Rule]", "\"\\\\beta\""}], ",", 
                    RowBox[{"\"\\\\[Gamma]\"", "\[Rule]", "\"\\\\gamma\""}], 
                    ",", 
                    RowBox[{"\"\[Gamma]\"", "\[Rule]", "\"\\\\gamma\""}], ",", 
                    RowBox[{"\"\\\\[Delta]\"", "\[Rule]", "\"\\\\delta\""}], 
                    ",", 
                    RowBox[{"\"\[Delta]\"", "\[Rule]", "\"\\\\delta\""}], ",", 
                    RowBox[{"\"\\\\[Theta]\"", "\[Rule]", "\"\\\\theta\""}], 
                    ",", 
                    RowBox[{"\"\[Theta]\"", "\[Rule]", "\"\\\\theta\""}], ",", 
                    RowBox[{"\"\\\\[Lambda]\"", "\[Rule]", "\"\\\\lambda\""}],
                     ",", 
                    RowBox[{"\"\[Lambda]\"", "\[Rule]", "\"\\\\lambda\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Mu]\"", "\[Rule]", "\"\\\\mu\""}], ",", 
                    RowBox[{"\"\[Mu]\"", "\[Rule]", "\"\\\\mu\""}], ",", 
                    RowBox[{"\"\\\\[Sigma]\"", "\[Rule]", "\"\\\\sigma\""}], 
                    ",", 
                    RowBox[{"\"\[Sigma]\"", "\[Rule]", "\"\\\\sigma\""}], ",", 
                    RowBox[{"\"\\\\[Phi]\"", "\[Rule]", "\"\\\\phi\""}], ",", 
                    
                    RowBox[{"\"\[CurlyPhi]\"", "\[Rule]", "\"\\\\phi\""}], 
                    ",", 
                    RowBox[{"\"\\\\[Omega]\"", "\[Rule]", "\"\\\\omega\""}], 
                    ",", 
                    RowBox[{"\"\[Omega]\"", "\[Rule]", "\"\\\\omega\""}]}], 
                    "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`step3", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`step2", ",", 
                    
                    RowBox[{"RegularExpression", "[", "\"[=+\\\\-*/()^_]\"", 
                    "]"}]}], "]"}], "||", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`step2", ",", 
                    
                    RowBox[{"RegularExpression", "[", 
                    "\"\\\\b[fghpqrstuvwxyz]\\\\s*\\\\(\"", "]"}]}], "]"}], 
                    "||", 
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`step2", ",", 
                    
                    RowBox[{"RegularExpression", "[", "\"\\\\\\\\[a-zA-Z]+\"",
                     "]"}]}], "]"}]}], ",", 
                    
                    RowBox[{"\"$\"", "<>", "VilTeX`Private`step2", "<>", 
                    "\"$\""}], ",", "VilTeX`Private`step2"}], "]"}]}], ";", 
                    
                    RowBox[{"VilTeX`Private`cleanText", "=", 
                    "VilTeX`Private`step3"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`position", "]"}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`position", "]"}], 
                    "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pos1", ",", 
                    "VilTeX`Private`pos2"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pos1", "=", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`position", "\[LeftDoubleBracket]",
                     "1", "\[RightDoubleBracket]"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`pos2", "=", 
                    RowBox[{"N", "[", 
                    
                    RowBox[{"VilTeX`Private`position", "\[LeftDoubleBracket]",
                     "2", "\[RightDoubleBracket]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"NumericQ", "[", "VilTeX`Private`pos1", "]"}], 
                    "&&", 
                    RowBox[{"NumericQ", "[", "VilTeX`Private`pos2", "]"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`extractedTexts", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`extractedTexts", ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`cleanText", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pos1", ",", 
                    "VilTeX`Private`pos2"}], "}"}]}], "}"}]}], "]"}]}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], 
                    "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`allTexts", "]"}]}],
                     "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`combinedTexts", "=", 
                    "VilTeX`Private`extractedTexts"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`texto", "]"}], ">",
                     "0"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`texto", "]"}], 
                    "\[Equal]", "2"}], "&&", 
                    RowBox[{"StringQ", "[", 
                    
                    RowBox[{"VilTeX`Private`texto", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`texto", "\[LeftDoubleBracket]", 
                    "2", "\[RightDoubleBracket]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`combinedTexts", "=", 
                    RowBox[{"Append", "[", 
                    
                    RowBox[{"VilTeX`Private`combinedTexts", ",", 
                    "VilTeX`Private`texto"}], "]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`combinedTexts", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`combinedTexts", ",", 
                    "VilTeX`Private`texto"}], "]"}]}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";", 
                    
                    RowBox[{"VilTeX`Private`extractedTexts", "=", 
                    "VilTeX`Private`combinedTexts"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`folderName", "=", 
                    
                    RowBox[{"FileBaseName", "[", "VilTeX`Private`filename", 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`folderPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"$HomeDirectory", ",", "\"Downloads\"", ",", 
                    "VilTeX`Private`folderName"}], "}"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"DirectoryQ", "[", "VilTeX`Private`folderPath", 
                    "]"}]}], ",", 
                    
                    RowBox[{"CreateDirectory", "[", 
                    "VilTeX`Private`folderPath", "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`downloadPath", "=", 
                    RowBox[{"FileNameJoin", "[", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`folderPath", ",", 
                    "VilTeX`Private`filename"}], "}"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"{", "}"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`plot", ",", "_Graphics"}], "]"}], 
                    ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`primitives", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`plot", ",", 
                    RowBox[{
                    RowBox[{"Line", "[", "VilTeX`Private`pts_", "]"}], "|", 
                    RowBox[{"Point", "[", "VilTeX`Private`pts_", "]"}], "|", 
                    RowBox[{"Circle", "[", 
                    
                    RowBox[{"VilTeX`Private`center_", ",", 
                    "VilTeX`Private`radius_"}], "]"}], "|", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x1_", ",", "VilTeX`Private`y1_"}],
                     "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x2_", ",", "VilTeX`Private`y2_"}],
                     "}"}]}], "]"}], "|", 
                    RowBox[{"Disk", "[", 
                    
                    RowBox[{"VilTeX`Private`center_", ",", 
                    "VilTeX`Private`radius_"}], "]"}], "|", 
                    RowBox[{"Polygon", "[", "VilTeX`Private`pts_", "]"}], "|", 
                    RowBox[{"Arrow", "[", "VilTeX`Private`line_", "]"}], "|", 
                    
                    RowBox[{"Arrow", "[", "VilTeX`Private`pts_", "]"}]}], ",",
                     "\[Infinity]"}], "]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`primitive", "=", 
                    
                    RowBox[{"VilTeX`Private`primitives", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`primitive", ",", 
                    RowBox[{"Line", "[", "VilTeX`Private`pts_", "]"}]}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`pts", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pts", "]"}], ">", 
                    "1"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", "VilTeX`Private`pts"}], "}"}]}], 
                    "]"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`primitive", ",", 
                    RowBox[{"Point", "[", "VilTeX`Private`pts_", "]"}]}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`pts", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"point\"", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`pts", "\[LeftDoubleBracket]", 
                    "1", "\[RightDoubleBracket]"}], "]"}], ",", 
                    "VilTeX`Private`pts", ",", 
                    RowBox[{"{", "VilTeX`Private`pts", "}"}]}], "]"}]}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`primitive", ",", 
                    RowBox[{"Arrow", "[", "_", "]"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`arrowContent", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ",", "VilTeX`Private`pts"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Which", "[", 
                    RowBox[{
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`arrowContent", ",", 
                    RowBox[{"Line", "[", "VilTeX`Private`pts_", "]"}]}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pts", "=", 
                    
                    RowBox[{"VilTeX`Private`arrowContent", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ";"}], ",", 
                    RowBox[{
                    
                    RowBox[{"ListQ", "[", "VilTeX`Private`arrowContent", 
                    "]"}], "&&", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`arrowContent", 
                    "]"}], ">", "1"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`pts", "=", 
                    "VilTeX`Private`arrowContent"}], ";"}], ",", "True", ",", 
                    
                    RowBox[{
                    RowBox[{"VilTeX`Private`pts", "=", 
                    RowBox[{"{", "}"}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pts", "]"}], ">", 
                    "1"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"arrow\"", ",", "VilTeX`Private`pts"}], "}"}]}],
                     "]"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`primitive", ",", 
                    RowBox[{"Circle", "[", 
                    
                    RowBox[{"VilTeX`Private`center_", ",", 
                    "VilTeX`Private`radius_"}], "]"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ",", 
                    RowBox[{"VilTeX`Private`radius", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ",", "VilTeX`Private`circlePoints"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`circlePoints", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "+", 
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "VilTeX`Private`t", "]"}], ",", 
                    RowBox[{"Sin", "[", "VilTeX`Private`t", "]"}]}], 
                    "}"}]}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`t", ",", "0", ",", 
                    RowBox[{"2", " ", "\[Pi]"}], ",", 
                    FractionBox["\[Pi]", "50"]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", "VilTeX`Private`circlePoints"}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`primitive", ",", 
                    RowBox[{"Disk", "[", 
                    
                    RowBox[{"VilTeX`Private`center_", ",", 
                    "VilTeX`Private`radius_"}], "]"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ",", 
                    RowBox[{"VilTeX`Private`radius", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}]}], 
                    ",", "VilTeX`Private`circlePoints"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`circlePoints", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`center", "+", 
                    RowBox[{"VilTeX`Private`radius", " ", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"Cos", "[", "VilTeX`Private`t", "]"}], ",", 
                    RowBox[{"Sin", "[", "VilTeX`Private`t", "]"}]}], 
                    "}"}]}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`t", ",", "0", ",", 
                    RowBox[{"2", " ", "\[Pi]"}], ",", 
                    FractionBox["\[Pi]", "50"]}], "}"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", "VilTeX`Private`circlePoints"}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`primitive", ",", 
                    RowBox[{"Rectangle", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x1_", ",", "VilTeX`Private`y1_"}],
                     "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x2_", ",", "VilTeX`Private`y2_"}],
                     "}"}]}], "]"}]}], "]"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`x1", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`y1", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"1", ",", "2"}], "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`x2", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"2", ",", "1"}], "\[RightDoubleBracket]"}]}], ",", 
                    RowBox[{"VilTeX`Private`y2", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"2", ",", "2"}], "\[RightDoubleBracket]"}]}], ",",
                     "VilTeX`Private`rectPoints"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`rectPoints", "=", 
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x1", ",", "VilTeX`Private`y1"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x2", ",", "VilTeX`Private`y1"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x2", ",", "VilTeX`Private`y2"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x1", ",", "VilTeX`Private`y2"}], 
                    "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x1", ",", "VilTeX`Private`y1"}], 
                    "}"}]}], "}"}]}], ";", 
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", "VilTeX`Private`rectPoints"}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{"MatchQ", "[", 
                    RowBox[{"VilTeX`Private`primitive", ",", 
                    RowBox[{"Polygon", "[", "VilTeX`Private`pts_", "]"}]}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pts", "=", 
                    
                    RowBox[{"VilTeX`Private`primitive", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    ",", "VilTeX`Private`polyPoints"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pts", "]"}], ">", 
                    "2"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`polyPoints", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`pts", ",", 
                    
                    RowBox[{"VilTeX`Private`pts", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", "VilTeX`Private`polyPoints"}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}],
                     "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`primitives", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`allLines", ",", 
                    "VilTeX`Private`allPoints"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allLines", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`plot", ",", 
                    RowBox[{
                    RowBox[{"Line", "[", "VilTeX`Private`pts_", "]"}], 
                    "\[RuleDelayed]", "VilTeX`Private`pts"}], ",", 
                    "\[Infinity]"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`allPoints", "=", 
                    RowBox[{"Cases", "[", 
                    RowBox[{"VilTeX`Private`plot", ",", 
                    RowBox[{
                    RowBox[{"Point", "[", "VilTeX`Private`pts_", "]"}], 
                    "\[RuleDelayed]", "VilTeX`Private`pts"}], ",", 
                    "\[Infinity]"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`allLines", "]"}], 
                    "\[GreaterEqual]", "2"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`lineData", "=", 
                    RowBox[{"{", "}"}]}], ",", "VilTeX`Private`sortedLines"}],
                     "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pts", "=", 
                    
                    RowBox[{"VilTeX`Private`allLines", "\[LeftDoubleBracket]",
                     "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ",", 
                    "VilTeX`Private`characteristic"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pts", "]"}], ">", 
                    "100"}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`nearZero", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`pts", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "]"}], "<", "0.5`"}], "&"}]}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`characteristic", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`nearZero", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{"Mean", "[", 
                    RowBox[{"VilTeX`Private`nearZero", "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}], ",", "0"}], "]"}]}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`lineData", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`lineData", ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`characteristic", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`pts", "]"}]}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`allLines", "]"}]}],
                     "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`sortedLines", "=", 
                    RowBox[{"SortBy", "[", 
                    RowBox[{"VilTeX`Private`lineData", ",", 
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "&"}]}], "]"}]}], ";", 
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`lineIndex", "=", 
                    
                    RowBox[{"VilTeX`Private`sortedLines", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", 
                    
                    RowBox[{"VilTeX`Private`allLines", "\[LeftDoubleBracket]",
                     "VilTeX`Private`lineIndex", "\[RightDoubleBracket]"}]}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Min", "[", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`sortedLines", 
                    "]"}], ",", "2"}], "]"}]}], "}"}]}], "]"}], ";"}]}], 
                    "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", 
                    
                    RowBox[{"VilTeX`Private`allLines", "\[LeftDoubleBracket]",
                     "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], "}"}]}],
                     "]"}]}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`allLines", "]"}]}],
                     "}"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`allPoints", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Append", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{"{", 
                    RowBox[{"\"point\"", ",", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{"VilTeX`Private`allPoints", ",", "1"}], "]"}]}], 
                    "}"}]}], "]"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}],
                     "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`data", "]"}], 
                    "\[Equal]", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"\"line\"", ",", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`x", ",", 
                    RowBox[{"Sin", "[", "VilTeX`Private`x", "]"}]}], "}"}], 
                    ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`x", ",", "0", ",", "10", ",", 
                    "0.1`"}], "}"}]}], "]"}]}], "}"}], "}"}]}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`data", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`data", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "2"}], 
                    "&&", 
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "\[Equal]", "\"line\""}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], ">", "1"}]}], ")"}], 
                    "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "2"}], 
                    "&&", 
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "\[Equal]", "\"point\""}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], ">", "0"}]}], ")"}], 
                    "||", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "2"}], 
                    "&&", 
                    RowBox[{
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "\[Equal]", "\"arrow\""}], 
                    "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    
                    RowBox[{"#1", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "]"}], ">", "1"}]}], ")"}]}], 
                    "&"}]}], "]"}]}], ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", "=", 
                    "VilTeX`Private`styles"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Which", "[", 
                    RowBox[{
                    
                    RowBox[{"StringQ", "[", "VilTeX`Private`stylesParam", 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`isValidColorLocal", "[", 
                    "VilTeX`Private`stylesParam", "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"\"solid\"", ",", "VilTeX`Private`stylesParam"}], 
                    "}"}], "}"}]}], ";"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`isValidStyleLocal", "[", 
                    "VilTeX`Private`stylesParam", "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`stylesParam", ",", "\"black\""}], 
                    "}"}], "}"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"{", "}"}]}], ";"}]}], "]"}]}], "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`stylesParam", "]"}],
                     "&&", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`stylesParam", 
                    "]"}], "\[Equal]", "2"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`stylesParam", ",", "StringQ"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`isValidStyleLocal", "[", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "&&", 
                    RowBox[{"VilTeX`Private`isValidColorLocal", "[", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"{", "VilTeX`Private`stylesParam", "}"}]}], ";"}],
                     ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`isValidColorLocal", "[", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "&&", 
                    RowBox[{"VilTeX`Private`isValidStyleLocal", "[", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"{", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "2", "\[RightDoubleBracket]"}], 
                    ",", 
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}]}], 
                    "}"}], "}"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"{", "}"}]}], ";"}]}], "]"}]}], "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`stylesParam", "]"}],
                     "&&", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`stylesParam", 
                    "]"}], ">", "0"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`stylesParam", ",", "ListQ"}], 
                    "]"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`stylesParam", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[Equal]", "2"}], 
                    "&"}]}], "]"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    
                    RowBox[{"Flatten", "[", "VilTeX`Private`stylesParam", 
                    "]"}], ",", "StringQ"}], "]"}]}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    "VilTeX`Private`stylesParam"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`stylesParam", "]"}],
                     "&&", 
                    RowBox[{"AllTrue", "[", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", ",", 
                    "VilTeX`Private`isValidColorLocal"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"solid\"", ",", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`stylesParam", 
                    "]"}]}], "}"}]}], "]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`stylesParam", "]"}],
                     "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`stylesParam", ",", "StringQ"}], 
                    "]"}], "&&", 
                    RowBox[{"!", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"VilTeX`Private`stylesParam", ",", "ListQ"}], 
                    "]"}]}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`isValidColorLocal", "[", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"solid\"", ",", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`isValidStyleLocal", "[", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", "\"black\""}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"\"solid\"", ",", "\"black\""}], "}"}]}], "]"}]}],
                     "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`stylesParam", 
                    "]"}]}], "}"}]}], "]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"ListQ", "[", "VilTeX`Private`stylesParam", "]"}],
                     "&&", 
                    RowBox[{"AllTrue", "[", 
                    
                    RowBox[{"VilTeX`Private`stylesParam", ",", 
                    "VilTeX`Private`isValidStyleLocal"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`stylesParam", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], ",", "\"black\""}], "}"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`stylesParam", 
                    "]"}]}], "}"}]}], "]"}]}], ";"}], ",", 
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`stylesParam", 
                    "]"}], "\[Equal]", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"{", "}"}]}], ";"}], ",", "True", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`processedStyles", "=", 
                    RowBox[{"{", "}"}]}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`numOriginalFunctions", "=", 
                    RowBox[{"Length", "[", "VilTeX`Private`data", "]"}]}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`processedStyles", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`plotStyles", "=", 
                    "VilTeX`Private`processedStyles"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`plotStyles", "=", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"\"solid\"", ",", "\"black\""}], "}"}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`i", ",", 
                    "VilTeX`Private`numOriginalFunctions"}], "}"}]}], "]"}]}],
                     ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`data", "]"}], ">", 
                    "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allPoints", "=", 
                    RowBox[{"Flatten", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`dataType", ",", 
                    "VilTeX`Private`pts"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`dataType", ",", 
                    "VilTeX`Private`pts"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`data", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dataType", "\[Equal]", 
                    "\"line\""}], ",", "VilTeX`Private`pts", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pts", "]"}], ">", 
                    "0"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`pts", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}], "]"}]}], ",", 
                    "VilTeX`Private`pts", ",", 
                    RowBox[{"{", "VilTeX`Private`pts", "}"}]}], "]"}]}], 
                    "]"}]}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`data", "]"}]}], 
                    "}"}]}], "]"}], ",", "1"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`allPoints", "]"}], 
                    ">", "0"}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], "\[GreaterEqual]", "2"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}], ",", "VilTeX`Private`xmin"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "1"}], "\[RightDoubleBracket]"}], 
                    "]"}], ",", "VilTeX`Private`xmax"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"Min", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}], ",", "VilTeX`Private`ymin"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"Max", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}], ",", "VilTeX`Private`ymax"}], "]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Abs", "[", 
                    
                    RowBox[{"VilTeX`Private`ymaxFinal", "-", 
                    "VilTeX`Private`yminFinal"}], "]"}], ">", 
                    SuperscriptBox["10", "4"]}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`medianY", ",", 
                    "VilTeX`Private`rangeLimit"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`medianY", "=", 
                    RowBox[{"Median", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`rangeLimit", "=", 
                    RowBox[{"3", " ", 
                    RowBox[{"StandardDeviation", "[", 
                    
                    RowBox[{"VilTeX`Private`allPoints", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"All", ",", "2"}], "\[RightDoubleBracket]"}], 
                    "]"}]}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"NumericQ", "[", "VilTeX`Private`rangeLimit", 
                    "]"}], "&&", 
                    RowBox[{"VilTeX`Private`rangeLimit", ">", "0"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"Max", "[", 
                    RowBox[{"VilTeX`Private`yminFinal", ",", 
                    
                    RowBox[{"VilTeX`Private`medianY", "-", 
                    "VilTeX`Private`rangeLimit"}]}], "]"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", 
                    RowBox[{"Min", "[", 
                    RowBox[{"VilTeX`Private`ymaxFinal", ",", 
                    
                    RowBox[{"VilTeX`Private`medianY", "+", 
                    "VilTeX`Private`rangeLimit"}]}], "]"}]}]}], "]"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], "||", 
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xRange", "=", 
                    
                    RowBox[{"VilTeX`Private`xmaxFinal", "-", 
                    "VilTeX`Private`xminFinal"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xRange", ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`xminFinal", "=", 
                    RowBox[{"VilTeX`Private`xminFinal", "-", 
                    RowBox[{"0.05`", " ", "VilTeX`Private`xRange"}]}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "+", 
                    RowBox[{"0.05`", " ", "VilTeX`Private`xRange"}]}]}]}], 
                    "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], "||", 
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}]}], 
                    ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yRange", "=", 
                    
                    RowBox[{"VilTeX`Private`ymaxFinal", "-", 
                    "VilTeX`Private`yminFinal"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yRange", ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"VilTeX`Private`yminFinal", "-", 
                    RowBox[{"0.1`", " ", "VilTeX`Private`yRange"}]}]}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}], ",", 
                    
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "+", 
                    RowBox[{"0.1`", " ", "VilTeX`Private`yRange"}]}]}]}], 
                    "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], ",", 
                    "0", ",", "VilTeX`Private`xmin"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}], ",", 
                    "10", ",", "VilTeX`Private`xmax"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"-", "1"}], ",", "VilTeX`Private`ymin"}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}], ",", 
                    "1", ",", "VilTeX`Private`ymax"}], "]"}]}], ";"}]}], 
                    "]"}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmin", "===", "Automatic"}], ",", 
                    "0", ",", "VilTeX`Private`xmin"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xmax", "===", "Automatic"}], ",", 
                    "10", ",", "VilTeX`Private`xmax"}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymin", "===", "Automatic"}], ",", 
                    
                    RowBox[{"-", "1"}], ",", "VilTeX`Private`ymin"}], "]"}]}],
                     ";", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`ymax", "===", "Automatic"}], ",", 
                    "1", ",", "VilTeX`Private`ymax"}], "]"}]}], ";"}]}], 
                    "]"}], ";", 
                    RowBox[{"VilTeX`Private`xScale", "=", "1"}], ";", 
                    RowBox[{"VilTeX`Private`yScale", "=", "1"}], ";", 
                    RowBox[{"VilTeX`Private`xLabel", "=", "\"$x$\""}], ";", 
                    RowBox[{"VilTeX`Private`yLabel", "=", "\"$y$\""}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`xminFinal", "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`xminFinal", "=", 
                    RowBox[{"-", "5"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`xmaxFinal", "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", "5"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`yminFinal", "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    RowBox[{"-", "5"}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"!", 
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`ymaxFinal", "]"}]}], ",", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", "5"}]}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`xminFinal", "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`xmaxFinal", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`xminFinal", "]"}], 
                    ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`xmaxFinal", "]"}]}], 
                    "]"}], ">", "1000"}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`xminFinal", "]"}], 
                    ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`xmaxFinal", "]"}]}], 
                    "]"}], ">", 
                    SuperscriptBox["10", "6"]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xScale", "=", 
                    SuperscriptBox["10", "6"]}], ";", 
                    
                    RowBox[{"VilTeX`Private`xLabel", "=", 
                    "\"$x$ ($\\\\times 10^6$)\""}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`xminFinal", "]"}], 
                    ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`xmaxFinal", "]"}]}], 
                    "]"}], ">", "1000"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`xScale", "=", "1000"}], ";", 
                    
                    RowBox[{"VilTeX`Private`xLabel", "=", 
                    "\"$x$ ($\\\\times 10^3$)\""}]}]}], "]"}]}], "]"}]}], 
                    "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`yminFinal", "]"}], "&&", 
                    
                    RowBox[{"VilTeX`Private`validNumber", "[", 
                    "VilTeX`Private`ymaxFinal", "]"}], "&&", 
                    RowBox[{
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`yminFinal", "]"}], 
                    ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`ymaxFinal", "]"}]}], 
                    "]"}], ">", "1000"}]}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`maxAbsY", "=", 
                    RowBox[{"Max", "[", 
                    RowBox[{
                    RowBox[{"Abs", "[", "VilTeX`Private`yminFinal", "]"}], 
                    ",", 
                    RowBox[{"Abs", "[", "VilTeX`Private`ymaxFinal", "]"}]}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`maxAbsY", ">", 
                    SuperscriptBox["10", "6"]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yScale", "=", 
                    SuperscriptBox["10", "6"]}], ";", 
                    
                    RowBox[{"VilTeX`Private`yLabel", "=", 
                    "\"$y$ ($\\\\times 10^6$)\""}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`maxAbsY", ">", "10000"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yScale", "=", "10000"}], ";", 
                    
                    RowBox[{"VilTeX`Private`yLabel", "=", 
                    "\"$y$ ($\\\\times 10^4$)\""}]}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`maxAbsY", ">", "1000"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`yScale", "=", "1000"}], ";", 
                    
                    RowBox[{"VilTeX`Private`yLabel", "=", 
                    "\"$y$ ($\\\\times 10^3$)\""}]}]}], "]"}]}], "]"}]}], 
                    "]"}]}], "]"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`xminFinal", "=", 
                    FractionBox[
                    "VilTeX`Private`xminFinal", "VilTeX`Private`xScale"]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`xmaxFinal", "=", 
                    FractionBox[
                    "VilTeX`Private`xmaxFinal", "VilTeX`Private`xScale"]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`yminFinal", "=", 
                    FractionBox[
                    "VilTeX`Private`yminFinal", "VilTeX`Private`yScale"]}], 
                    ";", 
                    RowBox[{"VilTeX`Private`ymaxFinal", "=", 
                    FractionBox[
                    "VilTeX`Private`ymaxFinal", "VilTeX`Private`yScale"]}], 
                    ";", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`allPointPositions", "=", 
                    RowBox[{"{", "}"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`data", "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}], "\[Equal]", "\"point\""}], ",", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`pointList", "=", 
                    RowBox[{"VilTeX`Private`data", "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pointList", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`pointList", 
                    "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], 
                    "]"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allPointPositions", "=", 
                    RowBox[{"Join", "[", 
                    
                    RowBox[{"VilTeX`Private`allPointPositions", ",", 
                    "VilTeX`Private`pointList"}], "]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`allPointPositions", "=", 
                    RowBox[{"Append", "[", 
                    
                    RowBox[{"VilTeX`Private`allPointPositions", ",", 
                    "VilTeX`Private`pointList"}], "]"}]}], ";"}]}], "]"}], 
                    ";"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`data", "]"}]}], 
                    "}"}]}], "]"}], ";", 
                    RowBox[{"VilTeX`Private`textAnnotations", "=", "\"\""}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`extractedTexts", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"Do", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`textoStr", ",", 
                    "VilTeX`Private`coordenadas", ",", 
                    "VilTeX`Private`xCoord", ",", "VilTeX`Private`yCoord", 
                    ",", "VilTeX`Private`formattedText", ",", 
                    "VilTeX`Private`adjustedPos"}], "}"}], ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`textoStr", ",", 
                    "VilTeX`Private`coordenadas"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`extractedTexts", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`adjustedPos", "=", 
                    RowBox[{"VilTeX`Private`adjustLabelPosition", "[", 
                    
                    RowBox[{"VilTeX`Private`coordenadas", ",", 
                    "VilTeX`Private`allPointPositions"}], "]"}]}], ";", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`xCoord", ",", 
                    "VilTeX`Private`yCoord"}], "}"}], "=", 
                    "VilTeX`Private`adjustedPos"}], ";", 
                    RowBox[{"VilTeX`Private`formattedText", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"StringStartsQ", "[", 
                    RowBox[{"VilTeX`Private`textoStr", ",", "\"$\""}], "]"}], 
                    "&&", 
                    RowBox[{"StringEndsQ", "[", 
                    RowBox[{"VilTeX`Private`textoStr", ",", "\"$\""}], 
                    "]"}]}], ",", "VilTeX`Private`textoStr", ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{"StringContainsQ", "[", 
                    RowBox[{"VilTeX`Private`textoStr", ",", "\"\\\\\""}], 
                    "]"}], ",", "VilTeX`Private`textoStr", ",", 
                    
                    RowBox[{"VilTeX`Private`formatMathText", "[", 
                    "VilTeX`Private`textoStr", "]"}]}], "]"}]}], "]"}]}], ";", 
                    RowBox[{"VilTeX`Private`textAnnotations", "=", 
                    
                    RowBox[{"VilTeX`Private`textAnnotations", "<>", 
                    "\"\\\\node at (axis cs:\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    FractionBox[
                    "VilTeX`Private`xCoord", "VilTeX`Private`xScale"], "]"}], 
                    "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    FractionBox[
                    "VilTeX`Private`yCoord", "VilTeX`Private`yScale"], "]"}], 
                    "<>", "\") {\"", "<>", "VilTeX`Private`formattedText", 
                    "<>", "\"};\\n\""}]}], ";"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`extractedTexts", 
                    "]"}]}], "}"}]}], "]"}], ";"}]}], "]"}], ";"}]}], "]"}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tikzCode", "=", 
                    
                    RowBox[{"\"\\\\begin{tikzpicture}\\n\"", "<>", 
                    "\"\\\\begin{axis}[\\n\"", "<>", "\"  xlabel={\"", "<>", 
                    "VilTeX`Private`xLabel", "<>", "\"},\\n\"", "<>", 
                    "\"  ylabel={\"", "<>", "VilTeX`Private`yLabel", "<>", 
                    "\"},\\n\"", "<>", "\"  xmin=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xminFinal", "]"}], "<>", "\",\\n\"", "<>",
                     "\"  xmax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`xmaxFinal", "]"}], "<>", "\",\\n\"", "<>",
                     "\"  ymin=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`yminFinal", "]"}], "<>", "\",\\n\"", "<>",
                     "\"  ymax=\"", "<>", 
                    
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    "VilTeX`Private`ymaxFinal", "]"}], "<>", "\",\\n\"", "<>",
                     "\"  scaled ticks=false,\\n\"", "<>", 
                    "\"  tick label style={/pgf/number format/fixed},\\n\"", 
                    "<>", 
                    RowBox[{"If", "[", 
                    
                    RowBox[{"VilTeX`Private`grid", ",", 
                    "\"  grid=major,\\n\"", ",", "\"\""}], "]"}], "<>", 
                    RowBox[{"If", "[", 
                    
                    RowBox[{"VilTeX`Private`ejes", ",", 
                    "\"  axis lines=center\\n\"", ",", 
                    "\"  axis lines=none\\n\""}], "]"}], "<>", "\"]\\n\"", 
                    "<>", 
                    RowBox[{"StringJoin", "[", 
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`dataType", ",", 
                    "VilTeX`Private`pts", ",", "VilTeX`Private`style", ",", 
                    "VilTeX`Private`color", ",", 
                    "VilTeX`Private`tikzLineStyle", ",", 
                    "VilTeX`Private`tikzThickness", ",", 
                    RowBox[{"VilTeX`Private`result", "=", "\"\""}]}], "}"}], 
                    ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`dataType", ",", 
                    "VilTeX`Private`pts"}], "}"}], "=", 
                    
                    RowBox[{"VilTeX`Private`data", "\[LeftDoubleBracket]", 
                    "VilTeX`Private`i", "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dataType", "\[Equal]", 
                    "\"line\""}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pts", "]"}], ">", 
                    "1"}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dataType", "\[Equal]", 
                    "\"point\""}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pts", "]"}], ">", 
                    "0"}]}], ")"}], "||", 
                    RowBox[{"(", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dataType", "\[Equal]", 
                    "\"arrow\""}], "&&", 
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pts", "]"}], ">", 
                    "1"}]}], ")"}]}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"VilTeX`Private`i", "\[LessEqual]", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`plotStyles", 
                    "]"}]}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`plotStyles", 
                    "\[LeftDoubleBracket]", "VilTeX`Private`i", 
                    "\[RightDoubleBracket]"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`style", "=", 
                    
                    RowBox[{"VilTeX`Private`plotStyles", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "1"}], 
                    "\[RightDoubleBracket]"}]}], ";", 
                    RowBox[{"VilTeX`Private`color", "=", 
                    
                    RowBox[{"VilTeX`Private`plotStyles", 
                    "\[LeftDoubleBracket]", 
                    RowBox[{"VilTeX`Private`i", ",", "2"}], 
                    "\[RightDoubleBracket]"}]}], ";"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`style", "=", "\"solid\""}], ";", 
                    RowBox[{"VilTeX`Private`color", "=", "\"black\""}], 
                    ";"}]}], "]"}], ";", 
                    RowBox[{"Which", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`style", "\[Equal]", 
                    "\"dashed\""}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`tikzLineStyle", "=", 
                    "\"dashed\""}], ";", 
                    
                    RowBox[{"VilTeX`Private`tikzThickness", "=", 
                    "\"thick\""}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`style", "\[Equal]", 
                    "\"dotted\""}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`tikzLineStyle", "=", 
                    "\"dotted\""}], ";", 
                    
                    RowBox[{"VilTeX`Private`tikzThickness", "=", 
                    "\"thick\""}]}], ",", 
                    
                    RowBox[{"VilTeX`Private`style", "\[Equal]", 
                    "\"dashdotted\""}], ",", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`tikzLineStyle", "=", 
                    "\"dashdotted\""}], ";", 
                    
                    RowBox[{"VilTeX`Private`tikzThickness", "=", 
                    "\"thick\""}]}], ",", 
                    RowBox[{"VilTeX`Private`style", "\[Equal]", "\"thick\""}],
                     ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzLineStyle", "=", "\"\""}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tikzThickness", "=", 
                    "\"very thick\""}]}], ",", "True", ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`tikzLineStyle", "=", "\"\""}], 
                    ";", 
                    RowBox[{"VilTeX`Private`tikzThickness", "=", 
                    "\"thick\""}]}]}], "]"}], ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dataType", "\[Equal]", 
                    "\"line\""}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`validPts", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`pts", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[GreaterEqual]", 
                    "2"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "NumericQ"}], "]"}]}], "&"}]}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`validPts", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`result", "=", 
                    
                    RowBox[{"\"\\\\addplot[\"", "<>", "VilTeX`Private`color", 
                    "<>", "\", \"", "<>", "VilTeX`Private`tikzThickness", 
                    "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`tikzLineStyle", "\[NotEqual]", 
                    "\"\""}], ",", 
                    RowBox[{"\", \"", "<>", "VilTeX`Private`tikzLineStyle"}], 
                    ",", "\"\""}], "]"}], "<>", "\"] coordinates {\\n\"", 
                    "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    FractionBox[
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "VilTeX`Private`xScale"], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    FractionBox[
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "VilTeX`Private`yScale"], 
                    "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pt", ",", 
                    "VilTeX`Private`validPts"}], "}"}]}], "]"}], ",", 
                    "\"\\n\""}], "]"}], "<>", "\"\\n};\\n\""}]}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`dataType", "\[Equal]", 
                    "\"arrow\""}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`validPts", "=", 
                    RowBox[{"Select", "[", 
                    RowBox[{"VilTeX`Private`pts", ",", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "#1", "]"}], "\[GreaterEqual]", 
                    "2"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{"#1", ",", "NumericQ"}], "]"}]}], "&"}]}], 
                    "]"}]}], "}"}], ",", 
                    RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`validPts", "]"}], 
                    ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`result", "=", 
                    
                    RowBox[{"\"\\\\addplot[\"", "<>", "VilTeX`Private`color", 
                    "<>", "\", \"", "<>", "VilTeX`Private`tikzThickness", 
                    "<>", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    
                    RowBox[{"VilTeX`Private`tikzLineStyle", "\[NotEqual]", 
                    "\"\""}], ",", 
                    RowBox[{"\", \"", "<>", "VilTeX`Private`tikzLineStyle"}], 
                    ",", "\"\""}], "]"}], "<>", 
                    "\", -stealth] coordinates {\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    FractionBox[
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "VilTeX`Private`xScale"], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    FractionBox[
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "VilTeX`Private`yScale"], 
                    "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pt", ",", 
                    "VilTeX`Private`validPts"}], "}"}]}], "]"}], ",", 
                    "\"\\n\""}], "]"}], "<>", "\"\\n};\\n\""}]}], ";"}]}], 
                    "]"}], ";"}]}], "]"}], ",", 
                    RowBox[{"Module", "[", 
                    RowBox[{
                    RowBox[{"{", "VilTeX`Private`pointList", "}"}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`pointList", "=", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pts", "]"}], ">", 
                    "0"}], "&&", 
                    RowBox[{"ListQ", "[", 
                    
                    RowBox[{"VilTeX`Private`pts", "\[LeftDoubleBracket]", "1",
                     "\[RightDoubleBracket]"}], "]"}]}], ",", 
                    "VilTeX`Private`pts", ",", 
                    RowBox[{"{", "VilTeX`Private`pts", "}"}]}], "]"}]}], ";", 
                    
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", "VilTeX`Private`pointList", "]"}], 
                    ">", "0"}], "&&", 
                    RowBox[{"AllTrue", "[", 
                    RowBox[{
                    RowBox[{"Flatten", "[", "VilTeX`Private`pointList", "]"}],
                     ",", "NumericQ"}], "]"}]}], ",", 
                    RowBox[{
                    RowBox[{"VilTeX`Private`result", "=", 
                    
                    RowBox[{"\"\\\\addplot[\"", "<>", "VilTeX`Private`color", 
                    "<>", "\", only marks, mark=*, mark size=2pt] coordinates \
{\\n\"", "<>", 
                    RowBox[{"StringRiffle", "[", 
                    RowBox[{
                    RowBox[{"Table", "[", 
                    RowBox[{
                    RowBox[{"\"  (\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    FractionBox[
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "1", 
                    "\[RightDoubleBracket]"}], "VilTeX`Private`xScale"], 
                    "]"}], "<>", "\",\"", "<>", 
                    RowBox[{"VilTeX`Private`formatNumber", "[", 
                    FractionBox[
                    
                    RowBox[{"VilTeX`Private`pt", "\[LeftDoubleBracket]", "2", 
                    "\[RightDoubleBracket]"}], "VilTeX`Private`yScale"], 
                    "]"}], "<>", "\")\""}], ",", 
                    RowBox[{"{", 
                    
                    RowBox[{"VilTeX`Private`pt", ",", 
                    "VilTeX`Private`pointList"}], "}"}]}], "]"}], ",", 
                    "\"\\n\""}], "]"}], "<>", "\"\\n};\\n\""}]}], ";"}]}], 
                    "]"}], ";"}]}], "]"}]}], "]"}]}], "]"}], ";"}]}], "]"}], 
                    ";", "VilTeX`Private`result"}]}], "]"}], ",", 
                    RowBox[{"{", 
                    RowBox[{"VilTeX`Private`i", ",", 
                    RowBox[{"Length", "[", "VilTeX`Private`data", "]"}]}], 
                    "}"}]}], "]"}], "]"}], "<>", 
                    "VilTeX`Private`textAnnotations", "<>", 
                    "\"\\\\end{axis}\\n\"", "<>", 
                    "\"\\\\end{tikzpicture}\""}]}], ";", 
                    RowBox[{"VilTeX`Private`fullDocument", "=", 
                    
                    RowBox[{
                    "\"\\\\documentclass[border=5mm]{standalone}\\n\"", "<>", 
                    "\"\\\\usepackage{tikz}\\n\"", "<>", 
                    "\"\\\\usepackage{pgfplots}\\n\"", "<>", 
                    "\"\\\\usepackage{amsmath}\\n\"", "<>", 
                    "\"\\\\usepackage{amssymb}\\n\"", "<>", 
                    "\"\\\\pgfplotsset{compat=1.18}\\n\"", "<>", 
                    "\"\\\\pgfplotsset{scaled ticks=false}\\n\"", "<>", 
                    "\"\\\\pgfplotsset{tick label style={/pgf/number \
format/fixed}}\\n\"", "<>", "\"\\n\"", "<>", "\"\\\\begin{document}\\n\"", 
                    "<>", "VilTeX`Private`tikzCode", "<>", 
                    "\"\\n\\\\end{document}\""}]}], ";", 
                    RowBox[{"Export", "[", 
                    
                    RowBox[{"VilTeX`Private`downloadPath", ",", 
                    "VilTeX`Private`fullDocument", ",", "\"Text\""}], "]"}], 
                    ";", 
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    
                    RowBox[{"Length", "[", "VilTeX`Private`extractedTexts", 
                    "]"}], ">", "0"}], ",", 
                    RowBox[{
                    RowBox[{"Print", "[", 
                    
                    RowBox[{
                    "\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: \"", 
                    "<>", 
                    RowBox[{"ToString", "[", 
                    
                    RowBox[{"Length", "[", "VilTeX`Private`extractedTexts", 
                    "]"}], "]"}], "<>", "\" elementos\""}], "]"}], ";"}]}], 
                    "]"}], ";", "VilTeX`Private`downloadPath"}]}], "]"}]}]}, {
                   " "}}, GridBoxAlignment -> {"Columns" -> {{Left}}}, 
                  DefaultBaseStyle -> "Column", 
                  GridBoxItemSize -> {
                   "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}]},
                "RowDefault"]}
             },
             DefaultBaseStyle->"Column",
             GridBoxAlignment->{"Columns" -> {{Left}}},
             
             GridBoxItemSize->{
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
            "Column"],
           FrameMargins->{{6, 0}, {3, 6}}], "\<\"\"\>"},
         {
          PaneBox[GridBox[{
             {
              
              DynamicModuleBox[{System`InformationDump`open$$ = {
               False, False, False, False, False, False}}, 
               StyleBox[GridBox[{
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Attributes\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"Attributes\"",
                    TooltipStyle->"TextStyling"],
                    Annotation[#, "Attributes", "Tooltip"]& ], 
                   RowBox[{"{", "Protected", "}"}]},
                  {
                   TagBox[
                    TooltipBox[
                    StyleBox["\<\" Full Name\"\>", "InformationRowLabel",
                    StripOnInput->False],
                    "\"FullName\"",
                    TooltipStyle->"TextStyling"],
                    
                    Annotation[#, "FullName", 
                    "Tooltip"]& ], "\<\"VilTeX`ExportToTikZ\"\>"}
                 },
                 AutoDelete->False,
                 GridBoxAlignment->{"Columns" -> {Right, Left}},
                 GridBoxDividers->None,
                 GridBoxItemSize->{"Columns" -> {Automatic, Automatic}},
                 GridBoxSpacings->{"Columns" -> {
                    Offset[0.27999999999999997`], {
                    Offset[0.5599999999999999]}, 
                    Offset[0.27999999999999997`]}, "Rows" -> {
                    Offset[0.2], {
                    Offset[0.8]}, 
                    Offset[0.2]}}], "DialogStyle",
                StripOnInput->False],
               DynamicModuleValues:>{}]}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            GridBoxDividers->{"Columns" -> {{False}}, "Rows" -> {{False}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
            GridBoxSpacings->{"Columns" -> {
                Offset[0.27999999999999997`], {
                 Offset[0.5599999999999999]}, 
                Offset[0.27999999999999997`]}, "Rows" -> {
                Offset[0.2], {
                 Offset[3.6]}, 
                Offset[0.2]}}],
           FrameMargins->{{6, 6}, {6, 3}}], ""},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpener"]], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "UpPointerOpenerHot"]]}, Dynamic[
              System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, False],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"], False->
      TagBox[GridBox[{
         {
          ItemBox[
           PaneBox[
            StyleBox[
             TagBox[
              TooltipBox[
               StyleBox["\<\" Symbol\"\>", "InformationRowLabel",
                StripOnInput->False],
               "\"Symbol\"",
               TooltipStyle->"TextStyling"],
              Annotation[#, "Symbol", "Tooltip"]& ], "InformationTitleText",
             StripOnInput->False],
            FrameMargins->{{4, 0}, {-1, 1}}],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           PaneBox[
            
            StyleBox["\<\"ExportToTikZ[plot, filename, grid, styles, ejes, \
texto, xmin, xmax, ymin, ymax] convierte un gr\[AAcute]fico de Mathematica a \
c\[OAcute]digo TikZ/LaTeX y lo exporta como archivo .tex.\\n\\nPAR\
\[CapitalAAcute]METROS:\\n\\nplot: Gr\[AAcute]fico v\[AAcute]lido de \
Mathematica. Acepta:\\n  - Graphics (objetos gr\[AAcute]ficos puros)\\n  - \
Plot, ListPlot, DiscretePlot, ParametricPlot, PolarPlot\\n  - Show (combinaci\
\[OAcute]n de gr\[AAcute]ficos)\\n\\nfilename: String con el nombre del \
archivo de salida.\\n  - DEBE incluir extensi\[OAcute]n .tex\\n  - Ejemplo: \
\\\"migr\[AAcute]fico.tex\\\"\\n\\ngrid: Booleano (opcional, por defecto \
True).\\n  - True: Muestra rejilla mayor en el gr\[AAcute]fico\\n  - False: \
Sin rejilla\\n\\nstyles: Especificaci\[OAcute]n de estilos (opcional, por \
defecto {}).\\n  Formatos acepatados:\\n  - String \[UAcute]nico: \\\"red\\\" \
o \\\"dashed\\\"\\n  - Par: {\\\"dashed\\\", \\\"blue\\\"} o {\\\"blue\\\", \
\\\"dashed\\\"}\\n  - Lista de colores/estilos: {\\\"red\\\", \\\"blue\\\"} o \
{\\\"solid\\\", \\\"dashed\\\"}\\n  - Matriz: {{\\\"solid\\\", \\\"red\\\"}, \
{\\\"dashed\\\", \\\"blue\\\"}}\\n  \\n  Colores v\[AAcute]lidos: red, blue, \
green, orange, purple, black, brown, pink, gray, cyan, magenta, yellow, lime, \
olive, teal\\n  \\n  Estilos v\[AAcute]lidos: solid, dashed, dotted, \
dashdotted, thick\\n\\nejes: Booleano (opcional, por defecto True).\\n  - \
True: Muestra ejes centrados (axis lines=center)\\n  - False: Sin ejes (axis \
lines=none)\\n\\ntexto: Anotaciones de texto (opcional, por defecto {}).\\n  \
Formatos aceptados:\\n  - {} (vac\[IAcute]o)\\n  - {\\\"texto\\\", {x, y}} \
(una sola anotaci\[OAcute]n)\\n  - {{\\\"texto1\\\", {x1, y1}}, {\\\"texto2\\\
\", {x2, y2}}, ...} (m\[UAcute]ltiples anotaciones)\\n  \\n  NOTA: La funci\
\[OAcute]n extrae autom\[AAcute]ticamente textos existentes en el \
gr\[AAcute]fico\\n\\nxmin, xmax, ymin, ymax: L\[IAcute]mites de los ejes \
(opcionales, por defecto Automatic).\\n  - Automatic: Calcula \
autom\[AAcute]ticamente basado en los datos\\n  - N\[UAcute]mero \
v\[AAcute]lido: Especifica l\[IAcute]mite manual\\n  - xmin debe ser menor \
que xmax\\n  - ymin debe ser menor que ymax\\n\\nRETORNA: Ruta completa del \
archivo exportado.\\n\\nFUNCIONALIDADES ESPECIALES:\\n- Extrae \
autom\[AAcute]ticamente textos del gr\[AAcute]fico original\\n- Ajusta posici\
\[OAcute]n de etiquetas para evitar solapamiento con puntos\\n- Detecta \
expresiones matem\[AAcute]ticas y las formatea correctamente\\n- Aplica \
escalado autom\[AAcute]tico para valores grandes (>1000)\\n- Maneja \
m\[UAcute]ltiples tipos de primitivas gr\[AAcute]ficas\\n- Crea carpeta de \
descarga autom\[AAcute]ticamente\\n- Genera documento LaTeX completo y \
compilable\\n\\nEJEMPLOS:\\nExportToTikZ[Plot[Sin[x], {x, 0, 2\[Pi]}], \
\\\"seno.tex\\\"]\\nExportToTikZ[plot, \\\"gr\[AAcute]fico.tex\\\", True, \
\\\"red\\\", True, {}, -5, 5, -2, 2]\\nExportToTikZ[plot, \\\"styled.tex\\\", \
False, {{\\\"dashed\\\", \\\"blue\\\"}, {\\\"solid\\\", \\\"red\\\"}}]\"\>", 
             "InformationUsageText",
             StripOnInput->False,
             LineSpacing->{1.5, 1.5, 3.}],
            FrameMargins->{{10, 10}, {8, 10}},
            ScrollPosition->{0., 0.}],
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False], 
          ItemBox["\<\"\"\>",
           BaseStyle->"InformationUsageSubtitleBackground",
           StripOnInput->False]},
         {
          ItemBox[
           TagBox[
            ButtonBox[
             PaneSelectorBox[{False->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpener"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}], True->
              
              DynamicBox[FEPrivate`FrontEndResource[
               "FEBitmaps", "DownPointerOpenerHot"],
               ImageSizeCache->{20., {2.8017578125, 17.1982421875}}]}, 
              Dynamic[System`InformationDump`mouseOver$$]],
             Alignment->Left,
             Appearance->{"Default" -> None},
             
             ButtonFunction:>FEPrivate`Set[
              System`InformationDump`open$$, True],
             Evaluator->Automatic,
             FrameMargins->{{9, 0}, {0, 0}},
             ImageMargins->0,
             ImageSize->Full,
             Method->"Preemptive"],
            
            EventHandlerTag[{
             "MouseEntered" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, True], 
              "MouseExited" :> 
              FEPrivate`Set[System`InformationDump`mouseOver$$, False], 
              Method -> "Preemptive", PassEventsDown -> Automatic, 
              PassEventsUp -> True}]],
           BaseStyle->"InformationTitleBackground",
           StripOnInput->False], "\[SpanFromLeft]"}
        },
        AutoDelete->False,
        FrameStyle->Directive[
          LightDarkSwitched[
           GrayLevel[0.8]], 
          Thickness[Tiny]],
        GridBoxAlignment->{"Columns" -> {Left, Right}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {{None}}, "Rows" -> {False, {True}, False}},
        GridBoxItemSize->{
         "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
       "Grid"]}, Dynamic[System`InformationDump`open$$],
      BaselinePosition->Baseline,
      FrameMargins->0,
      ImageSize->Automatic],
     DynamicModuleValues:>{}],
    BaseStyle->"InformationGridFrame",
    StripOnInput->False], "InformationGridPlain",
   StripOnInput->False],
  InformationData[<|
   "ObjectType" -> "Symbol", "Usage" -> 
    "ExportToTikZ[plot, filename, grid, styles, ejes, texto, xmin, xmax, \
ymin, ymax] convierte un gr\[AAcute]fico de Mathematica a c\[OAcute]digo \
TikZ/LaTeX y lo exporta como archivo .tex.\n\nPAR\[CapitalAAcute]METROS:\n\n\
plot: Gr\[AAcute]fico v\[AAcute]lido de Mathematica. Acepta:\n  - Graphics \
(objetos gr\[AAcute]ficos puros)\n  - Plot, ListPlot, DiscretePlot, \
ParametricPlot, PolarPlot\n  - Show (combinaci\[OAcute]n de gr\[AAcute]ficos)\
\n\nfilename: String con el nombre del archivo de salida.\n  - DEBE incluir \
extensi\[OAcute]n .tex\n  - Ejemplo: \"migr\[AAcute]fico.tex\"\n\ngrid: \
Booleano (opcional, por defecto True).\n  - True: Muestra rejilla mayor en el \
gr\[AAcute]fico\n  - False: Sin rejilla\n\nstyles: Especificaci\[OAcute]n de \
estilos (opcional, por defecto {}).\n  Formatos acepatados:\n  - String \
\[UAcute]nico: \"red\" o \"dashed\"\n  - Par: {\"dashed\", \"blue\"} o \
{\"blue\", \"dashed\"}\n  - Lista de colores/estilos: {\"red\", \"blue\"} o {\
\"solid\", \"dashed\"}\n  - Matriz: {{\"solid\", \"red\"}, {\"dashed\", \
\"blue\"}}\n  \n  Colores v\[AAcute]lidos: red, blue, green, orange, purple, \
black, brown, pink, gray, cyan, magenta, yellow, lime, olive, teal\n  \n  \
Estilos v\[AAcute]lidos: solid, dashed, dotted, dashdotted, thick\n\nejes: \
Booleano (opcional, por defecto True).\n  - True: Muestra ejes centrados \
(axis lines=center)\n  - False: Sin ejes (axis lines=none)\n\ntexto: \
Anotaciones de texto (opcional, por defecto {}).\n  Formatos aceptados:\n  - \
{} (vac\[IAcute]o)\n  - {\"texto\", {x, y}} (una sola anotaci\[OAcute]n)\n  - \
{{\"texto1\", {x1, y1}}, {\"texto2\", {x2, y2}}, ...} (m\[UAcute]ltiples \
anotaciones)\n  \n  NOTA: La funci\[OAcute]n extrae autom\[AAcute]ticamente \
textos existentes en el gr\[AAcute]fico\n\nxmin, xmax, ymin, ymax: \
L\[IAcute]mites de los ejes (opcionales, por defecto Automatic).\n  - \
Automatic: Calcula autom\[AAcute]ticamente basado en los datos\n  - \
N\[UAcute]mero v\[AAcute]lido: Especifica l\[IAcute]mite manual\n  - xmin \
debe ser menor que xmax\n  - ymin debe ser menor que ymax\n\nRETORNA: Ruta \
completa del archivo exportado.\n\nFUNCIONALIDADES ESPECIALES:\n- Extrae \
autom\[AAcute]ticamente textos del gr\[AAcute]fico original\n- Ajusta posici\
\[OAcute]n de etiquetas para evitar solapamiento con puntos\n- Detecta \
expresiones matem\[AAcute]ticas y las formatea correctamente\n- Aplica \
escalado autom\[AAcute]tico para valores grandes (>1000)\n- Maneja \
m\[UAcute]ltiples tipos de primitivas gr\[AAcute]ficas\n- Crea carpeta de \
descarga autom\[AAcute]ticamente\n- Genera documento LaTeX completo y \
compilable\n\nEJEMPLOS:\nExportToTikZ[Plot[Sin[x], {x, 0, 2\[Pi]}], \
\"seno.tex\"]\nExportToTikZ[plot, \"gr\[AAcute]fico.tex\", True, \"red\", \
True, {}, -5, 5, -2, 2]\nExportToTikZ[plot, \"styled.tex\", False, {{\"dashed\
\", \"blue\"}, {\"solid\", \"red\"}}]", "Documentation" -> None, "OwnValues" -> 
    None, "UpValues" -> None, "DownValues" -> 
    Information`InformationValueForm[
     DownValues, VilTeX`ExportToTikZ, {VilTeX`ExportToTikZ[
         Pattern[VilTeX`Private`plot, 
          Blank[]], 
         Pattern[VilTeX`Private`filename, 
          Blank[]], 
         Optional[
          Pattern[VilTeX`Private`grid, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`styles, 
           Blank[]], {}], 
         Optional[
          Pattern[VilTeX`Private`ejes, 
           Blank[]], True], 
         Optional[
          Pattern[VilTeX`Private`texto, 
           Blank[]], {}], 
         Optional[
          Pattern[VilTeX`Private`xmin, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`xmax, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`ymin, 
           Blank[]], Automatic], 
         Optional[
          Pattern[VilTeX`Private`ymax, 
           Blank[]], Automatic]] :> 
       Module[{VilTeX`Private`data, VilTeX`Private`tikzCode, 
          VilTeX`Private`fullDocument, VilTeX`Private`downloadPath, 
          VilTeX`Private`folderName, VilTeX`Private`folderPath, 
          VilTeX`Private`plotRange, VilTeX`Private`xminFinal, 
          VilTeX`Private`xmaxFinal, VilTeX`Private`yminFinal, 
          VilTeX`Private`ymaxFinal, VilTeX`Private`formatNumber, 
          VilTeX`Private`validNumber, VilTeX`Private`xScale, 
          VilTeX`Private`yScale, VilTeX`Private`xLabel, VilTeX`Private`yLabel,
           VilTeX`Private`allPoints, VilTeX`Private`xRange, 
          VilTeX`Private`yRange, VilTeX`Private`plotStyles, 
          VilTeX`Private`processedStyles, VilTeX`Private`numOriginalFunctions,
           VilTeX`Private`textAnnotations, VilTeX`Private`extractedTexts}, 
         Clear[VilTeX`Private`Finite, VilTeX`Private`isValidColor, 
           VilTeX`Private`isValidStyle, VilTeX`Private`isValidColorLocal, 
           VilTeX`Private`isValidStyleLocal, 
           VilTeX`Private`adjustLabelPosition, VilTeX`Private`formatMathText, 
           VilTeX`Private`escapeLaTeXText, 
           VilTeX`Private`extractTextFromStyle, VilTeX`Private`SymbolQ]; If[
           And[
            Not[
             MatchQ[VilTeX`Private`plot, 
              Blank[Graphics]]], 
            Not[
             MatchQ[
              Head[VilTeX`Private`plot], 
              Alternatives[
              Plot, ListPlot, DiscretePlot, ParametricPlot, PolarPlot]]], 
            Not[
             MatchQ[VilTeX`Private`plot, 
              Blank[Show]]]], 
           Print["Error: El primer argumento debe ser un gr\[AAcute]fico v\
\[AAcute]lido (Plot, Graphics, ListPlot, DiscretePlot, ParametricPlot, \
PolarPlot, o Show)."]; Return[$Failed]; Null]; If[
           Not[
            StringQ[VilTeX`Private`filename]], 
           Print["Error: El segundo argumento debe ser un string con el \
nombre del archivo."]; Return[$Failed]; Null]; If[
           Not[
            StringEndsQ[VilTeX`Private`filename, ".tex"]], 
           Print["Error: El nombre del archivo debe tener extensi\[OAcute]n \
.tex"]; Return[$Failed]; Null]; If[
           Not[
            BooleanQ[VilTeX`Private`grid]], 
           Print["Error: El tercer argumento (grid) debe ser True o False."]; 
           Return[$Failed]; Null]; If[
           Not[
            BooleanQ[VilTeX`Private`ejes]], 
           Print["Error: El par\[AAcute]metro 'ejes' debe ser True o False."]; 
           Return[$Failed]; Null]; If[
           And[VilTeX`Private`xmin =!= Automatic, 
            Or[
             Not[
              NumericQ[VilTeX`Private`xmin]], 
             Not[
              VilTeX`Private`Finite[VilTeX`Private`xmin]]]], 
           Print["Error: xmin debe ser un n\[UAcute]mero v\[AAcute]lido o \
Automatic."]; Return[$Failed]; Null]; If[
           And[VilTeX`Private`xmax =!= Automatic, 
            Or[
             Not[
              NumericQ[VilTeX`Private`xmax]], 
             Not[
              VilTeX`Private`Finite[VilTeX`Private`xmax]]]], 
           Print["Error: xmax debe ser un n\[UAcute]mero v\[AAcute]lido o \
Automatic."]; Return[$Failed]; Null]; If[
           And[VilTeX`Private`ymin =!= Automatic, 
            Or[
             Not[
              NumericQ[VilTeX`Private`ymin]], 
             Not[
              VilTeX`Private`Finite[VilTeX`Private`ymin]]]], 
           Print["Error: ymin debe ser un n\[UAcute]mero v\[AAcute]lido o \
Automatic."]; Return[$Failed]; Null]; If[
           And[VilTeX`Private`ymax =!= Automatic, 
            Or[
             Not[
              NumericQ[VilTeX`Private`ymax]], 
             Not[
              VilTeX`Private`Finite[VilTeX`Private`ymax]]]], 
           Print["Error: ymax debe ser un n\[UAcute]mero v\[AAcute]lido o \
Automatic."]; Return[$Failed]; Null]; If[
           And[
           VilTeX`Private`xmin =!= Automatic, VilTeX`Private`xmax =!= 
            Automatic, VilTeX`Private`xmin >= VilTeX`Private`xmax], 
           Print["Error: xmin debe ser menor que xmax."]; Return[$Failed]; 
           Null]; If[
           And[
           VilTeX`Private`ymin =!= Automatic, VilTeX`Private`ymax =!= 
            Automatic, VilTeX`Private`ymin >= VilTeX`Private`ymax], 
           Print["Error: ymin debe ser menor que ymax."]; Return[$Failed]; 
           Null]; Module[{
           VilTeX`Private`textoValid = True, VilTeX`Private`textoError = ""}, 
           Which[Length[VilTeX`Private`texto] == 0, VilTeX`Private`textoValid = 
             True, 
             And[Length[VilTeX`Private`texto] == 2, 
              StringQ[
               Part[VilTeX`Private`texto, 1]], 
              ListQ[
               Part[VilTeX`Private`texto, 2]], Length[
                Part[VilTeX`Private`texto, 2]] == 2, 
              AllTrue[
               Part[VilTeX`Private`texto, 2], NumericQ]], 
             VilTeX`Private`textoValid = True, 
             And[
              ListQ[VilTeX`Private`texto], 
              AllTrue[VilTeX`Private`texto, And[
                ListQ[#], Length[#] == 2, 
                StringQ[
                 Part[#, 1]], 
                ListQ[
                 Part[#, 2]], Length[
                  Part[#, 2]] == 2, 
                AllTrue[
                 Part[#, 2], NumericQ]]& ]], VilTeX`Private`textoValid = True,
              True, VilTeX`Private`textoValid = False; 
             VilTeX`Private`textoError = 
              "El par\[AAcute]metro 'texto' debe tener uno de estos formatos:\
\n  - {} (vac\[IAcute]o)\n  - {\"texto\", {x, y}}\n  - {{\"texto1\", {x1, \
y1}}, {\"texto2\", {x2, y2}}, ...}"; Null]; If[
             Not[VilTeX`Private`textoValid], 
             Print["Error: " <> VilTeX`Private`textoError]; Return[$Failed]; 
             Null]; Null]; 
         Module[{VilTeX`Private`validationResult = True, 
            VilTeX`Private`errorMsg = ""}, VilTeX`Private`isValidColor[
              Pattern[VilTeX`Private`x, 
               Blank[]]] := And[
              StringQ[VilTeX`Private`x], 
              
              MemberQ[{
               "red", "blue", "green", "orange", "purple", "black", "brown", 
                "pink", "gray", "cyan", "magenta", "yellow", "lime", "olive", 
                "teal"}, VilTeX`Private`x]]; VilTeX`Private`isValidStyle[
              Pattern[VilTeX`Private`x, 
               Blank[]]] := And[
              StringQ[VilTeX`Private`x], 
              
              MemberQ[{"solid", "dashed", "dotted", "dashdotted", "thick"}, 
               VilTeX`Private`x]]; 
           Which[Length[VilTeX`Private`styles] == 0, 
             VilTeX`Private`validationResult = True, 
             StringQ[VilTeX`Private`styles], 
             If[
              And[
               Not[
                VilTeX`Private`isValidColor[VilTeX`Private`styles]], 
               Not[
                VilTeX`Private`isValidStyle[VilTeX`Private`styles]]], 
              VilTeX`Private`validationResult = False; 
              VilTeX`Private`errorMsg = ("String '" <> VilTeX`Private`styles) <> 
                "' no es un color o estilo v\[AAcute]lido."; Null], 
             And[
              ListQ[VilTeX`Private`styles], Length[VilTeX`Private`styles] == 
              2, 
              AllTrue[VilTeX`Private`styles, StringQ], 
              Not[
               AllTrue[VilTeX`Private`styles, ListQ]]], 
             If[
              And[
               Not[
                And[
                 VilTeX`Private`isValidStyle[
                  Part[VilTeX`Private`styles, 1]], 
                 VilTeX`Private`isValidColor[
                  Part[VilTeX`Private`styles, 2]]]], 
               Not[
                And[
                 VilTeX`Private`isValidColor[
                  Part[VilTeX`Private`styles, 1]], 
                 VilTeX`Private`isValidStyle[
                  Part[VilTeX`Private`styles, 2]]]]], 
              VilTeX`Private`validationResult = False; 
              VilTeX`Private`errorMsg = ("El par " <> 
                 ToString[VilTeX`Private`styles]) <> 
                " debe contener un estilo v\[AAcute]lido y un color \
v\[AAcute]lido."; Null], 
             And[
              ListQ[VilTeX`Private`styles], 
              AllTrue[VilTeX`Private`styles, StringQ], 
              Not[
               AllTrue[VilTeX`Private`styles, ListQ]]], 
             
             Module[{VilTeX`Private`invalidItems}, 
              VilTeX`Private`invalidItems = 
               Select[VilTeX`Private`styles, And[
                  Not[
                   VilTeX`Private`isValidColor[#]], 
                  Not[
                   VilTeX`Private`isValidStyle[#]]]& ]; 
              If[Length[VilTeX`Private`invalidItems] > 0, 
                VilTeX`Private`validationResult = False; 
                VilTeX`Private`errorMsg = 
                 "Los siguientes elementos no son v\[AAcute]lidos: " <> 
                  ToString[VilTeX`Private`invalidItems]; Null]; Null], 
             And[
              ListQ[VilTeX`Private`styles], 
              AllTrue[VilTeX`Private`styles, ListQ], 
              AllTrue[VilTeX`Private`styles, Length[#] == 2& ]], 
             Module[{VilTeX`Private`invalidPairs}, 
              VilTeX`Private`invalidPairs = 
               Select[VilTeX`Private`styles, Not[
                  And[
                   AllTrue[#, StringQ], 
                   Or[
                    And[
                    VilTeX`Private`isValidStyle[
                    Part[#, 1]], 
                    VilTeX`Private`isValidColor[
                    Part[#, 2]]], 
                    And[
                    VilTeX`Private`isValidColor[
                    Part[#, 1]], 
                    VilTeX`Private`isValidStyle[
                    Part[#, 2]]]]]]& ]; 
              If[Length[VilTeX`Private`invalidPairs] > 0, 
                VilTeX`Private`validationResult = False; 
                VilTeX`Private`errorMsg = 
                 "Los siguientes pares no son v\[AAcute]lidos: " <> 
                  ToString[VilTeX`Private`invalidPairs]; Null]; Null], True, 
             VilTeX`Private`validationResult = False; 
             VilTeX`Private`errorMsg = 
              "Formato de estilos no reconocido: " <> 
               ToString[VilTeX`Private`styles]; Null]; If[
             Not[VilTeX`Private`validationResult], 
             Print["Error en estilos: " <> VilTeX`Private`errorMsg]; 
             Print["Formatos v\[AAcute]lidos:"]; 
             Print["  - String \[UAcute]nico: \"red\" o \"dashed\""]; 
             Print["  - Par: {\"dashed\", \"blue\"} o {\"blue\", \
\"dashed\"}"]; 
             Print["  - Lista de colores/estilos: {\"red\", \"blue\"} o \
{\"black\"}"]; 
             Print["  - Lista de estilos: {\"solid\", \"dashed\", \
\"dotted\"}"]; 
             Print["  - Matriz: {{\"solid\", \"red\"}, {\"dashed\", \
\"blue\"}}"]; 
             Print["Colores v\[AAcute]lidos: red, blue, green, orange, \
purple, black, brown, pink, gray, cyan, magenta, yellow, lime, olive, teal"]; 
             Print["Estilos v\[AAcute]lidos: solid, dashed, dotted, \
dashdotted, thick"]; Return[$Failed]; Null]; Null]; 
         VilTeX`Private`isValidColorLocal[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := And[
            StringQ[VilTeX`Private`x], 
            
            MemberQ[{
             "red", "blue", "green", "orange", "purple", "black", "brown", 
              "pink", "gray", "cyan", "magenta", "yellow", "lime", "olive", 
              "teal"}, VilTeX`Private`x]]; VilTeX`Private`isValidStyleLocal[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := And[
            StringQ[VilTeX`Private`x], 
            
            MemberQ[{"solid", "dashed", "dotted", "dashdotted", "thick"}, 
             VilTeX`Private`x]]; VilTeX`Private`formatNumber[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := 
          Module[{VilTeX`Private`result, VilTeX`Private`num}, If[
              NumericQ[VilTeX`Private`x], 
              VilTeX`Private`num = N[VilTeX`Private`x]; 
              If[Abs[VilTeX`Private`num] < 10^(-10), VilTeX`Private`result = 
                "0", 
                If[
                Abs[VilTeX`Private`num] > 10^8, VilTeX`Private`result = 
                 ToString[
                   Round[VilTeX`Private`num, 1], InputForm], 
                 If[
                 Abs[VilTeX`Private`num] > 1000, VilTeX`Private`result = 
                  ToString[
                    Round[VilTeX`Private`num, 0.01], InputForm], 
                  VilTeX`Private`result = ToString[
                    Round[VilTeX`Private`num, 10^(-6)], InputForm]]]]; Null, 
              VilTeX`Private`result = "0"]; If[
              StringQ[VilTeX`Private`result], VilTeX`Private`result, 
              ToString[VilTeX`Private`result]]]; VilTeX`Private`validNumber[
            Pattern[VilTeX`Private`x, 
             Blank[]]] := And[
            NumericQ[VilTeX`Private`x], 
            Not[
             MatchQ[VilTeX`Private`x, 
              Blank[Complex]]], Abs[VilTeX`Private`x] < 10^10]; 
         VilTeX`Private`adjustLabelPosition[
            Pattern[VilTeX`Private`textPos, 
             Blank[]], 
            Pattern[VilTeX`Private`allPointPositions, 
             Blank[]], 
            Optional[
             Pattern[VilTeX`Private`offset, 
              Blank[]], 0.15]] := 
          Module[{VilTeX`Private`adjustedPos = VilTeX`Private`textPos, 
             VilTeX`Private`minDistance, VilTeX`Private`nearestPoint, 
             VilTeX`Private`dx, VilTeX`Private`dy, VilTeX`Private`distance}, 
            If[Length[VilTeX`Private`allPointPositions] > 0, 
              VilTeX`Private`minDistance = Infinity; 
              VilTeX`Private`nearestPoint = {0, 0}; 
              Do[VilTeX`Private`distance = 
                 EuclideanDistance[VilTeX`Private`textPos, 
                   Part[VilTeX`Private`allPointPositions, VilTeX`Private`i]]; 
                If[VilTeX`Private`distance < VilTeX`Private`minDistance, 
                  VilTeX`Private`minDistance = VilTeX`Private`distance; 
                  VilTeX`Private`nearestPoint = 
                   Part[VilTeX`Private`allPointPositions, VilTeX`Private`i]; 
                  Null], {VilTeX`Private`i, 
                 Length[VilTeX`Private`allPointPositions]}]; 
              If[VilTeX`Private`minDistance < VilTeX`Private`offset, 
                VilTeX`Private`dx = 
                 Part[VilTeX`Private`textPos, 1] - Part[
                  VilTeX`Private`nearestPoint, 1]; 
                VilTeX`Private`dy = 
                 Part[VilTeX`Private`textPos, 2] - Part[
                  VilTeX`Private`nearestPoint, 2]; If[
                  And[
                  Abs[VilTeX`Private`dx] < 0.01, Abs[VilTeX`Private`dy] < 
                   0.01], VilTeX`Private`adjustedPos = 
                   VilTeX`Private`nearestPoint + {
                    VilTeX`Private`offset, VilTeX`Private`offset}; Null, 
                  Module[{
                    VilTeX`Private`norm = 
                    Sqrt[VilTeX`Private`dx^2 + VilTeX`Private`dy^2]}, 
                    If[VilTeX`Private`norm > 0, 
                    VilTeX`Private`adjustedPos = 
                    VilTeX`Private`nearestPoint + {
                    VilTeX`Private`dx, VilTeX`Private`dy} (
                    VilTeX`Private`offset/VilTeX`Private`norm); Null, 
                    VilTeX`Private`adjustedPos = 
                    VilTeX`Private`nearestPoint + {
                    VilTeX`Private`offset, VilTeX`Private`offset}; Null]; 
                    Null]; Null]; Null]; Null]; VilTeX`Private`adjustedPos]; 
         VilTeX`Private`formatMathText[
            Pattern[VilTeX`Private`text, 
             Blank[String]]] := Module[{VilTeX`Private`result}, 
            If[
             Or[
              StringContainsQ[VilTeX`Private`text, 
               RegularExpression["[=+\\-*/()^_]"]], 
              StringContainsQ[VilTeX`Private`text, 
               RegularExpression["\\b[fghpqrstuvwxyz]\\s*\\("]], 
              StringContainsQ[VilTeX`Private`text, 
               RegularExpression["\\^\\d"]], 
              StringContainsQ[VilTeX`Private`text, 
               RegularExpression["[xyz]\\^"]], 
              StringContainsQ[VilTeX`Private`text, 
               RegularExpression["\\b(sin|cos|tan|log|ln|exp)\\b"]]], ("$" <> 
              VilTeX`Private`text) <> "$", 
             VilTeX`Private`escapeLaTeXText[VilTeX`Private`text]]]; 
         VilTeX`Private`escapeLaTeXText[
            Pattern[VilTeX`Private`text, 
             Blank[String]]] := 
          Module[{VilTeX`Private`result}, 
            VilTeX`Private`result = VilTeX`Private`text; 
            VilTeX`Private`result = 
             StringReplace[
              VilTeX`Private`result, {
               "\\" -> "\\textbackslash{}", "{" -> "\\{", "}" -> "\\}", "$" -> 
                "\\$", "&" -> "\\&", "%" -> "\\%", "#" -> "\\#", "^" -> 
                "\\textasciicircum{}", "_" -> "\\_", "~" -> 
                "\\textasciitilde{}"}]; VilTeX`Private`result]; 
         VilTeX`Private`extractTextFromStyle[
            Pattern[VilTeX`Private`styleObj, 
             Blank[]]] := 
          Module[{VilTeX`Private`textContent, VilTeX`Private`rawText}, 
            Which[
             MatchQ[VilTeX`Private`styleObj, 
              Style[
               Pattern[VilTeX`Private`text, 
                Blank[]], 
               BlankNullSequence[]]], 
             VilTeX`Private`rawText = Part[VilTeX`Private`styleObj, 1]; 
             VilTeX`Private`textContent = Which[
                StringQ[VilTeX`Private`rawText], VilTeX`Private`rawText, 
                VilTeX`Private`SymbolQ[VilTeX`Private`rawText], 
                ToString[VilTeX`Private`rawText, InputForm], True, 
                ToString[VilTeX`Private`rawText, InputForm]]; If[
               And[
                StringStartsQ[VilTeX`Private`textContent, "\""], 
                StringEndsQ[VilTeX`Private`textContent, "\""]], 
               VilTeX`Private`textContent = 
               StringTake[VilTeX`Private`textContent, {2, -2}]]; 
             VilTeX`Private`formatMathText[VilTeX`Private`textContent], 
             StringQ[VilTeX`Private`styleObj], 
             VilTeX`Private`formatMathText[VilTeX`Private`styleObj], 
             VilTeX`Private`SymbolQ[VilTeX`Private`styleObj], 
             VilTeX`Private`formatMathText[
              ToString[VilTeX`Private`styleObj, InputForm]], True, 
             VilTeX`Private`textContent = 
              ToString[VilTeX`Private`styleObj, InputForm]; If[
               And[
                StringStartsQ[VilTeX`Private`textContent, "\""], 
                StringEndsQ[VilTeX`Private`textContent, "\""]], 
               VilTeX`Private`textContent = 
               StringTake[VilTeX`Private`textContent, {2, -2}]]; 
             VilTeX`Private`formatMathText[VilTeX`Private`textContent]]]; 
         VilTeX`Private`extractedTexts = {}; 
         Module[{VilTeX`Private`allTexts}, 
           VilTeX`Private`allTexts = Cases[VilTeX`Private`plot, Text[
                Pattern[VilTeX`Private`content, 
                 Blank[]], 
                Pattern[VilTeX`Private`pos, 
                 Blank[]], 
                BlankNullSequence[]] :> {
               VilTeX`Private`content, VilTeX`Private`pos}, Infinity]; Do[
             
             Module[{VilTeX`Private`textContent, VilTeX`Private`position, 
               VilTeX`Private`cleanText, VilTeX`Private`stringContent, 
               VilTeX`Private`step1, VilTeX`Private`step2, 
               VilTeX`Private`step3}, {
                VilTeX`Private`textContent, VilTeX`Private`position} = 
               Part[VilTeX`Private`allTexts, VilTeX`Private`i]; 
              VilTeX`Private`stringContent = Which[
                 StringQ[VilTeX`Private`textContent], 
                 VilTeX`Private`textContent, 
                 MatchQ[VilTeX`Private`textContent, 
                  Style[
                   Pattern[VilTeX`Private`text, 
                    Blank[]], 
                   BlankNullSequence[]]], 
                 
                 Module[{
                  VilTeX`Private`innerText = 
                   Part[VilTeX`Private`textContent, 1]}, 
                  If[
                   StringQ[VilTeX`Private`innerText], 
                   VilTeX`Private`innerText, 
                   ToString[VilTeX`Private`innerText, InputForm]]], True, 
                 ToString[VilTeX`Private`textContent, InputForm]]; If[
                And[
                 StringQ[VilTeX`Private`stringContent], 
                 StringStartsQ[VilTeX`Private`stringContent, "\""], 
                 StringEndsQ[VilTeX`Private`stringContent, "\""]], 
                VilTeX`Private`stringContent = 
                 StringTake[VilTeX`Private`stringContent, {2, -2}]; Null]; 
              VilTeX`Private`step1 = VilTeX`Private`stringContent; 
              VilTeX`Private`step2 = 
               StringReplace[
                VilTeX`Private`step1, {
                 "\\[Pi]" -> "\\pi", "\[Pi]" -> "\\pi", "\\[Alpha]" -> 
                  "\\alpha", "\[Alpha]" -> "\\alpha", "\\[Beta]" -> "\\beta", 
                  "\[Beta]" -> "\\beta", "\\[Gamma]" -> "\\gamma", "\[Gamma]" -> 
                  "\\gamma", "\\[Delta]" -> "\\delta", "\[Delta]" -> 
                  "\\delta", "\\[Theta]" -> "\\theta", "\[Theta]" -> 
                  "\\theta", "\\[Lambda]" -> "\\lambda", "\[Lambda]" -> 
                  "\\lambda", "\\[Mu]" -> "\\mu", "\[Mu]" -> "\\mu", 
                  "\\[Sigma]" -> "\\sigma", "\[Sigma]" -> "\\sigma", 
                  "\\[Phi]" -> "\\phi", "\[CurlyPhi]" -> "\\phi", "\\[Omega]" -> 
                  "\\omega", "\[Omega]" -> "\\omega"}]; 
              VilTeX`Private`step3 = If[
                 Or[
                  StringContainsQ[VilTeX`Private`step2, 
                   RegularExpression["[=+\\-*/()^_]"]], 
                  StringContainsQ[VilTeX`Private`step2, 
                   RegularExpression["\\b[fghpqrstuvwxyz]\\s*\\("]], 
                  StringContainsQ[VilTeX`Private`step2, 
                   RegularExpression["\\\\[a-zA-Z]+"]]], ("$" <> 
                  VilTeX`Private`step2) <> "$", VilTeX`Private`step2]; 
              VilTeX`Private`cleanText = VilTeX`Private`step3; If[
                And[
                 ListQ[VilTeX`Private`position], 
                 Length[VilTeX`Private`position] >= 2], 
                Module[{VilTeX`Private`pos1, VilTeX`Private`pos2}, 
                  VilTeX`Private`pos1 = N[
                    Part[VilTeX`Private`position, 1]]; VilTeX`Private`pos2 = N[
                    Part[VilTeX`Private`position, 2]]; If[
                    And[
                    NumericQ[VilTeX`Private`pos1], 
                    NumericQ[VilTeX`Private`pos2]], 
                    VilTeX`Private`extractedTexts = 
                    Append[VilTeX`Private`extractedTexts, {
                    VilTeX`Private`cleanText, {
                    VilTeX`Private`pos1, VilTeX`Private`pos2}}]; Null]; Null]; 
                Null]; Null], {VilTeX`Private`i, 
              Length[VilTeX`Private`allTexts]}]; Null]; 
         Module[{VilTeX`Private`combinedTexts = 
            VilTeX`Private`extractedTexts}, 
           If[Length[VilTeX`Private`texto] > 0, If[
               And[Length[VilTeX`Private`texto] == 2, 
                StringQ[
                 Part[VilTeX`Private`texto, 1]], 
                ListQ[
                 Part[VilTeX`Private`texto, 2]]], 
               VilTeX`Private`combinedTexts = 
                Append[VilTeX`Private`combinedTexts, VilTeX`Private`texto]; 
               Null, VilTeX`Private`combinedTexts = 
                Join[VilTeX`Private`combinedTexts, VilTeX`Private`texto]; 
               Null]; Null]; 
           VilTeX`Private`extractedTexts = VilTeX`Private`combinedTexts; 
           Null]; VilTeX`Private`folderName = 
          FileBaseName[VilTeX`Private`filename]; 
         VilTeX`Private`folderPath = 
          FileNameJoin[{$HomeDirectory, "Downloads", 
             VilTeX`Private`folderName}]; If[
           Not[
            DirectoryQ[VilTeX`Private`folderPath]], 
           CreateDirectory[VilTeX`Private`folderPath]]; 
         VilTeX`Private`downloadPath = 
          FileNameJoin[{VilTeX`Private`folderPath, VilTeX`Private`filename}]; 
         VilTeX`Private`data = {}; If[
           MatchQ[VilTeX`Private`plot, 
            Blank[Graphics]], 
           Module[{VilTeX`Private`primitives = Cases[VilTeX`Private`plot, 
                Alternatives[
                 Line[
                  Pattern[VilTeX`Private`pts, 
                   Blank[]]], 
                 Point[
                  Pattern[VilTeX`Private`pts, 
                   Blank[]]], 
                 Circle[
                  Pattern[VilTeX`Private`center, 
                   Blank[]], 
                  Pattern[VilTeX`Private`radius, 
                   Blank[]]], 
                 Rectangle[{
                   Pattern[VilTeX`Private`x1, 
                    Blank[]], 
                   Pattern[VilTeX`Private`y1, 
                    Blank[]]}, {
                   Pattern[VilTeX`Private`x2, 
                    Blank[]], 
                   Pattern[VilTeX`Private`y2, 
                    Blank[]]}], 
                 Disk[
                  Pattern[VilTeX`Private`center, 
                   Blank[]], 
                  Pattern[VilTeX`Private`radius, 
                   Blank[]]], 
                 Polygon[
                  Pattern[VilTeX`Private`pts, 
                   Blank[]]], 
                 Arrow[
                  Pattern[VilTeX`Private`line, 
                   Blank[]]], 
                 Arrow[
                  Pattern[VilTeX`Private`pts, 
                   Blank[]]]], Infinity]}, Do[
               
               Module[{
                VilTeX`Private`primitive = 
                 Part[VilTeX`Private`primitives, VilTeX`Private`i]}, Which[
                  MatchQ[VilTeX`Private`primitive, 
                   Line[
                    Pattern[VilTeX`Private`pts, 
                    Blank[]]]], 
                  Module[{
                    VilTeX`Private`pts = Part[VilTeX`Private`primitive, 1]}, 
                    If[Length[VilTeX`Private`pts] > 1, 
                    VilTeX`Private`data = 
                    Append[VilTeX`Private`data, {"line", VilTeX`Private`pts}]; 
                    Null]; Null]; Null, 
                  MatchQ[VilTeX`Private`primitive, 
                   Point[
                    Pattern[VilTeX`Private`pts, 
                    Blank[]]]], 
                  Module[{
                    VilTeX`Private`pts = Part[VilTeX`Private`primitive, 1]}, 
                    VilTeX`Private`data = 
                    Append[VilTeX`Private`data, {"point", 
                    If[
                    ListQ[
                    Part[VilTeX`Private`pts, 1]], VilTeX`Private`pts, {
                    VilTeX`Private`pts}]}]; Null]; Null, 
                  MatchQ[VilTeX`Private`primitive, 
                   Arrow[
                    Blank[]]], 
                  Module[{
                    VilTeX`Private`arrowContent = 
                    Part[VilTeX`Private`primitive, 1], VilTeX`Private`pts}, 
                    Which[
                    MatchQ[VilTeX`Private`arrowContent, 
                    Line[
                    Pattern[VilTeX`Private`pts, 
                    Blank[]]]], 
                    VilTeX`Private`pts = Part[VilTeX`Private`arrowContent, 1]; 
                    Null, 
                    And[
                    ListQ[VilTeX`Private`arrowContent], 
                    Length[VilTeX`Private`arrowContent] > 1], 
                    VilTeX`Private`pts = VilTeX`Private`arrowContent; Null, 
                    True, VilTeX`Private`pts = {}; Null]; 
                    If[Length[VilTeX`Private`pts] > 1, 
                    VilTeX`Private`data = 
                    Append[VilTeX`Private`data, {
                    "arrow", VilTeX`Private`pts}]; Null]; Null]; Null, 
                  MatchQ[VilTeX`Private`primitive, 
                   Circle[
                    Pattern[VilTeX`Private`center, 
                    Blank[]], 
                    Pattern[VilTeX`Private`radius, 
                    Blank[]]]], 
                  Module[{
                    VilTeX`Private`center = Part[VilTeX`Private`primitive, 1],
                     VilTeX`Private`radius = 
                    Part[VilTeX`Private`primitive, 2], 
                    VilTeX`Private`circlePoints}, 
                    VilTeX`Private`circlePoints = 
                    Table[VilTeX`Private`center + VilTeX`Private`radius {
                    Cos[VilTeX`Private`t], 
                    Sin[VilTeX`Private`t]}, {
                    VilTeX`Private`t, 0, 2 Pi, Pi/50}]; 
                    VilTeX`Private`data = 
                    Append[VilTeX`Private`data, {
                    "line", VilTeX`Private`circlePoints}]; Null]; Null, 
                  MatchQ[VilTeX`Private`primitive, 
                   Disk[
                    Pattern[VilTeX`Private`center, 
                    Blank[]], 
                    Pattern[VilTeX`Private`radius, 
                    Blank[]]]], 
                  Module[{
                    VilTeX`Private`center = Part[VilTeX`Private`primitive, 1],
                     VilTeX`Private`radius = 
                    Part[VilTeX`Private`primitive, 2], 
                    VilTeX`Private`circlePoints}, 
                    VilTeX`Private`circlePoints = 
                    Table[VilTeX`Private`center + VilTeX`Private`radius {
                    Cos[VilTeX`Private`t], 
                    Sin[VilTeX`Private`t]}, {
                    VilTeX`Private`t, 0, 2 Pi, Pi/50}]; 
                    VilTeX`Private`data = 
                    Append[VilTeX`Private`data, {
                    "line", VilTeX`Private`circlePoints}]; Null]; Null, 
                  MatchQ[VilTeX`Private`primitive, 
                   Rectangle[{
                    Pattern[VilTeX`Private`x1, 
                    Blank[]], 
                    Pattern[VilTeX`Private`y1, 
                    Blank[]]}, {
                    Pattern[VilTeX`Private`x2, 
                    Blank[]], 
                    Pattern[VilTeX`Private`y2, 
                    Blank[]]}]], 
                  Module[{
                    VilTeX`Private`x1 = Part[VilTeX`Private`primitive, 1, 1], 
                    VilTeX`Private`y1 = Part[VilTeX`Private`primitive, 1, 2], 
                    VilTeX`Private`x2 = Part[VilTeX`Private`primitive, 2, 1], 
                    VilTeX`Private`y2 = Part[VilTeX`Private`primitive, 2, 2], 
                    VilTeX`Private`rectPoints}, 
                    VilTeX`Private`rectPoints = {{
                    VilTeX`Private`x1, VilTeX`Private`y1}, {
                    VilTeX`Private`x2, VilTeX`Private`y1}, {
                    VilTeX`Private`x2, VilTeX`Private`y2}, {
                    VilTeX`Private`x1, VilTeX`Private`y2}, {
                    VilTeX`Private`x1, VilTeX`Private`y1}}; 
                    VilTeX`Private`data = 
                    Append[VilTeX`Private`data, {
                    "line", VilTeX`Private`rectPoints}]; Null]; Null, 
                  MatchQ[VilTeX`Private`primitive, 
                   Polygon[
                    Pattern[VilTeX`Private`pts, 
                    Blank[]]]], 
                  Module[{
                    VilTeX`Private`pts = Part[VilTeX`Private`primitive, 1], 
                    VilTeX`Private`polyPoints}, 
                    If[Length[VilTeX`Private`pts] > 2, 
                    VilTeX`Private`polyPoints = Append[VilTeX`Private`pts, 
                    Part[VilTeX`Private`pts, 1]]; 
                    VilTeX`Private`data = 
                    Append[VilTeX`Private`data, {
                    "line", VilTeX`Private`polyPoints}]; Null]; Null]; Null]; 
                Null], {VilTeX`Private`i, 
                Length[VilTeX`Private`primitives]}]; Null]; Null, 
           Module[{VilTeX`Private`allLines, VilTeX`Private`allPoints}, 
             VilTeX`Private`allLines = Cases[VilTeX`Private`plot, Line[
                  Pattern[VilTeX`Private`pts, 
                   Blank[]]] :> VilTeX`Private`pts, Infinity]; 
             VilTeX`Private`allPoints = Cases[VilTeX`Private`plot, Point[
                  Pattern[VilTeX`Private`pts, 
                   Blank[]]] :> VilTeX`Private`pts, Infinity]; 
             If[Length[VilTeX`Private`allLines] >= 2, 
               Module[{
                 VilTeX`Private`lineData = {}, VilTeX`Private`sortedLines}, Do[
                   
                   Module[{
                    VilTeX`Private`pts = 
                    Part[VilTeX`Private`allLines, VilTeX`Private`i], 
                    VilTeX`Private`characteristic}, 
                    If[Length[VilTeX`Private`pts] > 100, 
                    Module[{
                    VilTeX`Private`nearZero = Select[VilTeX`Private`pts, Abs[
                    Part[#, 1]] < 0.5& ]}, 
                    VilTeX`Private`characteristic = 
                    If[Length[VilTeX`Private`nearZero] > 0, 
                    Mean[
                    Part[VilTeX`Private`nearZero, All, 2]], 0]; Null]; 
                    VilTeX`Private`lineData = 
                    Append[VilTeX`Private`lineData, {
                    VilTeX`Private`i, VilTeX`Private`characteristic, 
                    Length[VilTeX`Private`pts]}]; Null]; Null], {
                   VilTeX`Private`i, 
                    Length[VilTeX`Private`allLines]}]; 
                 VilTeX`Private`sortedLines = 
                  SortBy[VilTeX`Private`lineData, Part[#, 2]& ]; Do[
                   
                   Module[{
                    VilTeX`Private`lineIndex = 
                    Part[VilTeX`Private`sortedLines, VilTeX`Private`i, 1]}, 
                    VilTeX`Private`data = Append[VilTeX`Private`data, {"line", 
                    Part[VilTeX`Private`allLines, VilTeX`Private`lineIndex]}]; 
                    Null], {VilTeX`Private`i, 
                    Min[
                    Length[VilTeX`Private`sortedLines], 2]}]; Null]; Null, 
               Do[VilTeX`Private`data = Append[VilTeX`Private`data, {"line", 
                    Part[VilTeX`Private`allLines, VilTeX`Private`i]}], {
                 VilTeX`Private`i, 
                  Length[VilTeX`Private`allLines]}]; Null]; 
             If[Length[VilTeX`Private`allPoints] > 0, 
               VilTeX`Private`data = Append[VilTeX`Private`data, {"point", 
                   Flatten[VilTeX`Private`allPoints, 1]}]; Null]; Null]; 
           Null]; If[
          Length[VilTeX`Private`data] == 0, VilTeX`Private`data = {{"line", 
               Table[{VilTeX`Private`x, 
                 Sin[VilTeX`Private`x]}, {VilTeX`Private`x, 0, 10, 0.1}]}}; 
           Null]; VilTeX`Private`data = Select[VilTeX`Private`data, Or[
             And[Length[#] == 2, Part[#, 1] == "line", Length[
                Part[#, 2]] > 1], 
             And[Length[#] == 2, Part[#, 1] == "point", Length[
                Part[#, 2]] > 0], 
             And[Length[#] == 2, Part[#, 1] == "arrow", Length[
                Part[#, 2]] > 1]]& ]; 
         Module[{VilTeX`Private`stylesParam = VilTeX`Private`styles}, Which[
             StringQ[VilTeX`Private`stylesParam], If[
               VilTeX`Private`isValidColorLocal[VilTeX`Private`stylesParam], 
               VilTeX`Private`processedStyles = {{
                  "solid", VilTeX`Private`stylesParam}}; Null, 
               If[
                VilTeX`Private`isValidStyleLocal[VilTeX`Private`stylesParam], 
                VilTeX`Private`processedStyles = {{
                   VilTeX`Private`stylesParam, "black"}}; Null, 
                VilTeX`Private`processedStyles = {}; Null]]; Null, 
             And[
              ListQ[VilTeX`Private`stylesParam], 
              Length[VilTeX`Private`stylesParam] == 2, 
              AllTrue[VilTeX`Private`stylesParam, StringQ]], If[
               And[
                VilTeX`Private`isValidStyleLocal[
                 Part[VilTeX`Private`stylesParam, 1]], 
                VilTeX`Private`isValidColorLocal[
                 Part[VilTeX`Private`stylesParam, 2]]], 
               VilTeX`Private`processedStyles = {VilTeX`Private`stylesParam}; 
               Null, 
               If[
                And[
                 VilTeX`Private`isValidColorLocal[
                  Part[VilTeX`Private`stylesParam, 1]], 
                 VilTeX`Private`isValidStyleLocal[
                  Part[VilTeX`Private`stylesParam, 2]]], 
                VilTeX`Private`processedStyles = {{
                    Part[VilTeX`Private`stylesParam, 2], 
                    Part[VilTeX`Private`stylesParam, 1]}}; Null, 
                VilTeX`Private`processedStyles = {}; Null]]; Null, 
             And[
              ListQ[VilTeX`Private`stylesParam], 
              Length[VilTeX`Private`stylesParam] > 0, 
              AllTrue[VilTeX`Private`stylesParam, ListQ], 
              AllTrue[VilTeX`Private`stylesParam, Length[#] == 2& ], 
              AllTrue[
               Flatten[VilTeX`Private`stylesParam], StringQ]], 
             VilTeX`Private`processedStyles = VilTeX`Private`stylesParam; 
             Null, 
             And[
              ListQ[VilTeX`Private`stylesParam], 
              AllTrue[
              VilTeX`Private`stylesParam, VilTeX`Private`isValidColorLocal]], 
             VilTeX`Private`processedStyles = Table[{"solid", 
                 Part[VilTeX`Private`stylesParam, VilTeX`Private`i]}, {
                VilTeX`Private`i, 
                 Length[VilTeX`Private`stylesParam]}]; Null, 
             And[
              ListQ[VilTeX`Private`stylesParam], 
              AllTrue[VilTeX`Private`stylesParam, StringQ], 
              Not[
               AllTrue[VilTeX`Private`stylesParam, ListQ]]], 
             VilTeX`Private`processedStyles = Table[
                If[
                 VilTeX`Private`isValidColorLocal[
                  Part[VilTeX`Private`stylesParam, VilTeX`Private`i]], {
                 "solid", 
                  Part[VilTeX`Private`stylesParam, VilTeX`Private`i]}, 
                 If[
                  VilTeX`Private`isValidStyleLocal[
                   Part[VilTeX`Private`stylesParam, VilTeX`Private`i]], {
                   Part[VilTeX`Private`stylesParam, VilTeX`Private`i], 
                   "black"}, {"solid", "black"}]], {VilTeX`Private`i, 
                 Length[VilTeX`Private`stylesParam]}]; Null, 
             And[
              ListQ[VilTeX`Private`stylesParam], 
              AllTrue[
              VilTeX`Private`stylesParam, VilTeX`Private`isValidStyleLocal]], 
             VilTeX`Private`processedStyles = Table[{
                 Part[VilTeX`Private`stylesParam, VilTeX`Private`i], 
                 "black"}, {VilTeX`Private`i, 
                 Length[VilTeX`Private`stylesParam]}]; Null, 
             Length[VilTeX`Private`stylesParam] == 0, 
             VilTeX`Private`processedStyles = {}; Null, True, 
             VilTeX`Private`processedStyles = {}; Null]; Null]; 
         VilTeX`Private`numOriginalFunctions = Length[VilTeX`Private`data]; 
         If[Length[VilTeX`Private`processedStyles] > 0, 
           VilTeX`Private`plotStyles = VilTeX`Private`processedStyles; Null, 
           VilTeX`Private`plotStyles = 
            Table[{"solid", "black"}, {
              VilTeX`Private`i, VilTeX`Private`numOriginalFunctions}]; Null]; 
         If[Length[VilTeX`Private`data] > 0, 
           VilTeX`Private`allPoints = Flatten[
              Table[
               
               Module[{
                VilTeX`Private`dataType, 
                 VilTeX`Private`pts}, {
                  VilTeX`Private`dataType, VilTeX`Private`pts} = 
                 Part[VilTeX`Private`data, VilTeX`Private`i]; 
                If[VilTeX`Private`dataType == "line", VilTeX`Private`pts, 
                  If[
                   And[Length[VilTeX`Private`pts] > 0, 
                    ListQ[
                    Part[VilTeX`Private`pts, 1]]], VilTeX`Private`pts, {
                   VilTeX`Private`pts}]]], {VilTeX`Private`i, 
                Length[VilTeX`Private`data]}], 1]; If[
             And[Length[VilTeX`Private`allPoints] > 0, Length[
                Part[VilTeX`Private`allPoints, 1]] >= 2], 
             VilTeX`Private`xminFinal = 
              If[VilTeX`Private`xmin === Automatic, 
                Min[
                 Part[VilTeX`Private`allPoints, All, 1]], 
                VilTeX`Private`xmin]; 
             VilTeX`Private`xmaxFinal = 
              If[VilTeX`Private`xmax === Automatic, 
                Max[
                 Part[VilTeX`Private`allPoints, All, 1]], 
                VilTeX`Private`xmax]; 
             VilTeX`Private`yminFinal = 
              If[VilTeX`Private`ymin === Automatic, 
                Min[
                 Part[VilTeX`Private`allPoints, All, 2]], 
                VilTeX`Private`ymin]; 
             VilTeX`Private`ymaxFinal = 
              If[VilTeX`Private`ymax === Automatic, 
                Max[
                 Part[VilTeX`Private`allPoints, All, 2]], 
                VilTeX`Private`ymax]; 
             If[Abs[VilTeX`Private`ymaxFinal - VilTeX`Private`yminFinal] > 
               10^4, Module[{
                 VilTeX`Private`medianY, VilTeX`Private`rangeLimit}, 
                 VilTeX`Private`medianY = Median[
                    Part[VilTeX`Private`allPoints, All, 2]]; 
                 VilTeX`Private`rangeLimit = 3 StandardDeviation[
                    Part[VilTeX`Private`allPoints, All, 2]]; If[
                   And[
                    NumericQ[VilTeX`Private`rangeLimit], 
                    VilTeX`Private`rangeLimit > 0], 
                   If[VilTeX`Private`ymin === Automatic, 
                    VilTeX`Private`yminFinal = 
                    Max[VilTeX`Private`yminFinal, VilTeX`Private`medianY - 
                    VilTeX`Private`rangeLimit]]; 
                   If[VilTeX`Private`ymax === Automatic, 
                    VilTeX`Private`ymaxFinal = 
                    Min[VilTeX`Private`ymaxFinal, VilTeX`Private`medianY + 
                    VilTeX`Private`rangeLimit]]; Null]; Null]; Null]; If[
               Or[
               VilTeX`Private`xmin === Automatic, VilTeX`Private`xmax === 
                Automatic], 
               VilTeX`Private`xRange = 
                VilTeX`Private`xmaxFinal - VilTeX`Private`xminFinal; 
               If[VilTeX`Private`xRange > 0, 
                 If[VilTeX`Private`xmin === Automatic, 
                   VilTeX`Private`xminFinal = 
                   VilTeX`Private`xminFinal - 0.05 VilTeX`Private`xRange]; 
                 If[VilTeX`Private`xmax === Automatic, 
                   VilTeX`Private`xmaxFinal = 
                   VilTeX`Private`xmaxFinal + 0.05 VilTeX`Private`xRange]; 
                 Null]; Null]; If[
               Or[
               VilTeX`Private`ymin === Automatic, VilTeX`Private`ymax === 
                Automatic], 
               VilTeX`Private`yRange = 
                VilTeX`Private`ymaxFinal - VilTeX`Private`yminFinal; 
               If[VilTeX`Private`yRange > 0, 
                 If[VilTeX`Private`ymin === Automatic, 
                   VilTeX`Private`yminFinal = 
                   VilTeX`Private`yminFinal - 0.1 VilTeX`Private`yRange]; 
                 If[VilTeX`Private`ymax === Automatic, 
                   VilTeX`Private`ymaxFinal = 
                   VilTeX`Private`ymaxFinal + 0.1 VilTeX`Private`yRange]; 
                 Null]; Null]; Null, 
             VilTeX`Private`xminFinal = 
              If[VilTeX`Private`xmin === Automatic, 0, VilTeX`Private`xmin]; 
             VilTeX`Private`xmaxFinal = 
              If[VilTeX`Private`xmax === Automatic, 10, VilTeX`Private`xmax]; 
             VilTeX`Private`yminFinal = 
              If[VilTeX`Private`ymin === Automatic, -1, VilTeX`Private`ymin]; 
             VilTeX`Private`ymaxFinal = 
              If[VilTeX`Private`ymax === Automatic, 1, VilTeX`Private`ymax]; 
             Null]; Null, 
           VilTeX`Private`xminFinal = 
            If[VilTeX`Private`xmin === Automatic, 0, VilTeX`Private`xmin]; 
           VilTeX`Private`xmaxFinal = 
            If[VilTeX`Private`xmax === Automatic, 10, VilTeX`Private`xmax]; 
           VilTeX`Private`yminFinal = 
            If[VilTeX`Private`ymin === Automatic, -1, VilTeX`Private`ymin]; 
           VilTeX`Private`ymaxFinal = 
            If[VilTeX`Private`ymax === Automatic, 1, VilTeX`Private`ymax]; 
           Null]; VilTeX`Private`xScale = 1; VilTeX`Private`yScale = 1; 
         VilTeX`Private`xLabel = "$x$"; VilTeX`Private`yLabel = "$y$"; If[
           Not[
            VilTeX`Private`validNumber[VilTeX`Private`xminFinal]], 
           VilTeX`Private`xminFinal = -5]; If[
           Not[
            VilTeX`Private`validNumber[VilTeX`Private`xmaxFinal]], 
           VilTeX`Private`xmaxFinal = 5]; If[
           Not[
            VilTeX`Private`validNumber[VilTeX`Private`yminFinal]], 
           VilTeX`Private`yminFinal = -5]; If[
           Not[
            VilTeX`Private`validNumber[VilTeX`Private`ymaxFinal]], 
           VilTeX`Private`ymaxFinal = 5]; If[
           And[
            VilTeX`Private`validNumber[VilTeX`Private`xminFinal], 
            VilTeX`Private`validNumber[VilTeX`Private`xmaxFinal], Max[
              Abs[VilTeX`Private`xminFinal], 
              Abs[VilTeX`Private`xmaxFinal]] > 1000], 
           If[Max[
              Abs[VilTeX`Private`xminFinal], 
              Abs[VilTeX`Private`xmaxFinal]] > 10^6, 
            VilTeX`Private`xScale = 10^6; 
            VilTeX`Private`xLabel = "$x$ ($\\times 10^6$)", 
            If[Max[
               Abs[VilTeX`Private`xminFinal], 
               Abs[VilTeX`Private`xmaxFinal]] > 1000, 
             VilTeX`Private`xScale = 1000; 
             VilTeX`Private`xLabel = "$x$ ($\\times 10^3$)"]]]; If[
           And[
            VilTeX`Private`validNumber[VilTeX`Private`yminFinal], 
            VilTeX`Private`validNumber[VilTeX`Private`ymaxFinal], Max[
              Abs[VilTeX`Private`yminFinal], 
              Abs[VilTeX`Private`ymaxFinal]] > 1000], 
           Module[{VilTeX`Private`maxAbsY = Max[
               Abs[VilTeX`Private`yminFinal], 
               Abs[VilTeX`Private`ymaxFinal]]}, 
            If[
            VilTeX`Private`maxAbsY > 10^6, VilTeX`Private`yScale = 10^6; 
             VilTeX`Private`yLabel = "$y$ ($\\times 10^6$)", 
             If[
             VilTeX`Private`maxAbsY > 10000, VilTeX`Private`yScale = 10000; 
              VilTeX`Private`yLabel = "$y$ ($\\times 10^4$)", 
              If[
              VilTeX`Private`maxAbsY > 1000, VilTeX`Private`yScale = 1000; 
               VilTeX`Private`yLabel = "$y$ ($\\times 10^3$)"]]]]]; 
         VilTeX`Private`xminFinal = 
          VilTeX`Private`xminFinal/VilTeX`Private`xScale; 
         VilTeX`Private`xmaxFinal = 
          VilTeX`Private`xmaxFinal/VilTeX`Private`xScale; 
         VilTeX`Private`yminFinal = 
          VilTeX`Private`yminFinal/VilTeX`Private`yScale; 
         VilTeX`Private`ymaxFinal = 
          VilTeX`Private`ymaxFinal/VilTeX`Private`yScale; 
         Module[{VilTeX`Private`allPointPositions = {}}, Do[
             If[
             Part[VilTeX`Private`data, VilTeX`Private`i, 1] == "point", 
              Module[{VilTeX`Private`pointList = 
                 Part[VilTeX`Private`data, VilTeX`Private`i, 2]}, 
                If[Length[VilTeX`Private`pointList] > 0, If[
                    ListQ[
                    Part[VilTeX`Private`pointList, 1]], 
                    VilTeX`Private`allPointPositions = 
                    Join[VilTeX`Private`allPointPositions, 
                    VilTeX`Private`pointList]; Null, 
                    VilTeX`Private`allPointPositions = 
                    Append[VilTeX`Private`allPointPositions, 
                    VilTeX`Private`pointList]; Null]; Null]; Null]; Null], {
             VilTeX`Private`i, 
              Length[VilTeX`Private`data]}]; 
           VilTeX`Private`textAnnotations = ""; 
           If[Length[VilTeX`Private`extractedTexts] > 0, Do[
               
               Module[{
                VilTeX`Private`textoStr, VilTeX`Private`coordenadas, 
                 VilTeX`Private`xCoord, VilTeX`Private`yCoord, 
                 VilTeX`Private`formattedText, 
                 VilTeX`Private`adjustedPos}, {
                  VilTeX`Private`textoStr, VilTeX`Private`coordenadas} = 
                 Part[VilTeX`Private`extractedTexts, VilTeX`Private`i]; 
                VilTeX`Private`adjustedPos = 
                 VilTeX`Private`adjustLabelPosition[
                  VilTeX`Private`coordenadas, 
                   VilTeX`Private`allPointPositions]; {
                  VilTeX`Private`xCoord, VilTeX`Private`yCoord} = 
                 VilTeX`Private`adjustedPos; VilTeX`Private`formattedText = If[
                   And[
                    StringStartsQ[VilTeX`Private`textoStr, "$"], 
                    StringEndsQ[VilTeX`Private`textoStr, "$"]], 
                   VilTeX`Private`textoStr, 
                   If[
                    StringContainsQ[VilTeX`Private`textoStr, "\\"], 
                    VilTeX`Private`textoStr, 
                    VilTeX`Private`formatMathText[VilTeX`Private`textoStr]]]; 
                VilTeX`Private`textAnnotations = ((((((
                    VilTeX`Private`textAnnotations <> "\\node at (axis cs:") <> 
                    VilTeX`Private`formatNumber[
                    VilTeX`Private`xCoord/VilTeX`Private`xScale]) <> ",") <> 
                    VilTeX`Private`formatNumber[
                    VilTeX`Private`yCoord/VilTeX`Private`yScale]) <> ") {") <> 
                   VilTeX`Private`formattedText) <> "};\n"; Null], {
               VilTeX`Private`i, 
                Length[VilTeX`Private`extractedTexts]}]; Null]; Null]; 
         VilTeX`Private`tikzCode = (((((((((((((((((((((((((((
                    "\\begin{tikzpicture}\n" <> "\\begin{axis}[\n") <> 
                    "  xlabel={") <> VilTeX`Private`xLabel) <> "},\n") <> 
                    "  ylabel={") <> VilTeX`Private`yLabel) <> "},\n") <> 
                    "  xmin=") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`xminFinal]) <> 
                    ",\n") <> "  xmax=") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`xmaxFinal]) <> 
                    ",\n") <> "  ymin=") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`yminFinal]) <> 
                    ",\n") <> "  ymax=") <> 
                    VilTeX`Private`formatNumber[VilTeX`Private`ymaxFinal]) <> 
                    ",\n") <> "  scaled ticks=false,\n") <> 
                  "  tick label style={/pgf/number format/fixed},\n") <> 
                 If[VilTeX`Private`grid, "  grid=major,\n", ""]) <> 
                If[VilTeX`Private`ejes, "  axis lines=center\n", 
                  "  axis lines=none\n"]) <> "]\n") <> StringJoin[
                Table[
                 
                 Module[{
                  VilTeX`Private`dataType, VilTeX`Private`pts, 
                   VilTeX`Private`style, VilTeX`Private`color, 
                   VilTeX`Private`tikzLineStyle, VilTeX`Private`tikzThickness,
                    VilTeX`Private`result = 
                   ""}, {VilTeX`Private`dataType, VilTeX`Private`pts} = 
                   Part[VilTeX`Private`data, VilTeX`Private`i]; If[
                    Or[
                    And[
                    VilTeX`Private`dataType == "line", 
                    Length[VilTeX`Private`pts] > 1], 
                    And[
                    VilTeX`Private`dataType == "point", 
                    Length[VilTeX`Private`pts] > 0], 
                    And[
                    VilTeX`Private`dataType == "arrow", 
                    Length[VilTeX`Private`pts] > 1]], If[
                    And[VilTeX`Private`i <= Length[VilTeX`Private`plotStyles], 
                    ListQ[
                    Part[VilTeX`Private`plotStyles, VilTeX`Private`i]]], 
                    VilTeX`Private`style = 
                    Part[VilTeX`Private`plotStyles, VilTeX`Private`i, 1]; 
                    VilTeX`Private`color = 
                    Part[VilTeX`Private`plotStyles, VilTeX`Private`i, 2]; 
                    Null, VilTeX`Private`style = "solid"; 
                    VilTeX`Private`color = "black"; Null]; 
                    Which[VilTeX`Private`style == "dashed", 
                    VilTeX`Private`tikzLineStyle = "dashed"; 
                    VilTeX`Private`tikzThickness = "thick", 
                    VilTeX`Private`style == "dotted", 
                    VilTeX`Private`tikzLineStyle = "dotted"; 
                    VilTeX`Private`tikzThickness = "thick", 
                    VilTeX`Private`style == "dashdotted", 
                    VilTeX`Private`tikzLineStyle = "dashdotted"; 
                    VilTeX`Private`tikzThickness = "thick", 
                    VilTeX`Private`style == "thick", 
                    VilTeX`Private`tikzLineStyle = ""; 
                    VilTeX`Private`tikzThickness = "very thick", True, 
                    VilTeX`Private`tikzLineStyle = ""; 
                    VilTeX`Private`tikzThickness = "thick"]; 
                    If[VilTeX`Private`dataType == "line", 
                    
                    Module[{
                    VilTeX`Private`validPts = 
                    Select[VilTeX`Private`pts, And[Length[#] >= 2, 
                    AllTrue[#, NumericQ]]& ]}, 
                    If[Length[VilTeX`Private`validPts] > 0, 
                    VilTeX`Private`result = (((((("\\addplot[" <> 
                    VilTeX`Private`color) <> ", ") <> 
                    VilTeX`Private`tikzThickness) <> 
                    If[VilTeX`Private`tikzLineStyle != "", ", " <> 
                    VilTeX`Private`tikzLineStyle, ""]) <> 
                    "] coordinates {\n") <> StringRiffle[
                    
                    Table[((("  (" <> 
                    VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 1]/VilTeX`Private`xScale]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 2]/VilTeX`Private`yScale]) <> 
                    ")", {VilTeX`Private`pt, VilTeX`Private`validPts}], 
                    "\n"]) <> "\n};\n"; Null]; Null], 
                    If[VilTeX`Private`dataType == "arrow", 
                    
                    Module[{
                    VilTeX`Private`validPts = 
                    Select[VilTeX`Private`pts, And[Length[#] >= 2, 
                    AllTrue[#, NumericQ]]& ]}, 
                    If[Length[VilTeX`Private`validPts] > 0, 
                    VilTeX`Private`result = (((((("\\addplot[" <> 
                    VilTeX`Private`color) <> ", ") <> 
                    VilTeX`Private`tikzThickness) <> 
                    If[VilTeX`Private`tikzLineStyle != "", ", " <> 
                    VilTeX`Private`tikzLineStyle, ""]) <> 
                    ", -stealth] coordinates {\n") <> StringRiffle[
                    
                    Table[((("  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 1]/VilTeX`Private`xScale]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 2]/VilTeX`Private`yScale]) <> 
                    ")", {VilTeX`Private`pt, VilTeX`Private`validPts}], 
                    "\n"]) <> "\n};\n"; Null]; Null], 
                    
                    Module[{VilTeX`Private`pointList}, 
                    VilTeX`Private`pointList = If[
                    And[Length[VilTeX`Private`pts] > 0, 
                    ListQ[
                    Part[VilTeX`Private`pts, 1]]], VilTeX`Private`pts, {
                    VilTeX`Private`pts}]; If[
                    And[Length[VilTeX`Private`pointList] > 0, 
                    AllTrue[
                    Flatten[VilTeX`Private`pointList], NumericQ]], 
                    VilTeX`Private`result = ((("\\addplot[" <> 
                    VilTeX`Private`color) <> 
                    ", only marks, mark=*, mark size=2pt] coordinates {\n") <> 
                    StringRiffle[
                    
                    Table[((("  (" <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 1]/VilTeX`Private`xScale]) <> 
                    ",") <> VilTeX`Private`formatNumber[
                    Part[VilTeX`Private`pt, 2]/VilTeX`Private`yScale]) <> 
                    ")", {VilTeX`Private`pt, VilTeX`Private`pointList}], 
                    "\n"]) <> "\n};\n"; Null]; Null]]]; Null]; 
                  VilTeX`Private`result], {VilTeX`Private`i, 
                  Length[VilTeX`Private`data]}]]) <> 
             VilTeX`Private`textAnnotations) <> "\\end{axis}\n") <> 
           "\\end{tikzpicture}"; 
         VilTeX`Private`fullDocument = ((((((((((
                    "\\documentclass[border=5mm]{standalone}\n" <> 
                    "\\usepackage{tikz}\n") <> "\\usepackage{pgfplots}\n") <> 
                   "\\usepackage{amsmath}\n") <> "\\usepackage{amssymb}\n") <> 
                 "\\pgfplotsset{compat=1.18}\n") <> 
                "\\pgfplotsset{scaled ticks=false}\n") <> 
               "\\pgfplotsset{tick label style={/pgf/number format/fixed}}\n\
") <> "\n") <> "\\begin{document}\n") <> VilTeX`Private`tikzCode) <> 
           "\n\\end{document}"; 
         Export[VilTeX`Private`downloadPath, VilTeX`Private`fullDocument, 
           "Text"]; If[
          Length[VilTeX`Private`extractedTexts] > 0, 
           Print[("Textos extra\[IAcute]dos autom\[AAcute]ticamente: " <> 
              ToString[
                Length[VilTeX`Private`extractedTexts]]) <> " elementos"]; 
           Null]; VilTeX`Private`downloadPath]}], "SubValues" -> None, 
    "DefaultValues" -> None, "NValues" -> None, "FormatValues" -> None, 
    "Options" -> None, "Attributes" -> {Protected}, "FullName" -> 
    "VilTeX`ExportToTikZ"|>, False]]], "Output",
 CellChangeTimes->{3.966933675062277*^9, 3.9669340122551327`*^9, 
  3.9669419106686373`*^9},
 CellLabel->
  "Out[417]=",ExpressionUUID->"0f204724-238c-4a40-8b41-2a4a31da6c02"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gr\[AAcute]ficas Plot", "Section",
 CellChangeTimes->{{3.966934051574233*^9, 3.966934057302459*^9}, {
  3.966936008907673*^9, 
  3.966936009335051*^9}},ExpressionUUID->"5f53e9d5-4b87-435f-85bf-\
e8f68cf192de"],

Cell[CellGroupData[{

Cell["Ejemplo 1: uso b\[AAcute]sico", "Subsection",
 CellChangeTimes->{{3.966934414067052*^9, 3.966934416273943*^9}, {
  3.9669364883894033`*^9, 
  3.966936491765872*^9}},ExpressionUUID->"fe34e813-8d0a-4393-9b3b-\
ef0eb40c407b"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plot1", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", "x", "]"}], "*", 
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "x"}], "/", "4"}], "]"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"4", "*", "Pi"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"plot1", ",", "\"\<plot1.tex\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.964712455234358*^9, 3.964712463723111*^9}, {
   3.9652947556199102`*^9, 3.96529477862123*^9}, {3.9652955637882*^9, 
   3.965295581271186*^9}, {3.965295676293775*^9, 3.965295805243567*^9}, {
   3.9652958470872717`*^9, 3.9652958629288797`*^9}, 3.965298723739974*^9, {
   3.9652994640871143`*^9, 3.9652995095194902`*^9}, {3.966934123983159*^9, 
   3.96693414225953*^9}, {3.9669341816170483`*^9, 3.966934181914598*^9}, {
   3.9669342936550217`*^9, 3.966934294564865*^9}, {3.966934345085341*^9, 
   3.966934353589432*^9}, {3.966934398621429*^9, 3.966934401694961*^9}, 
   3.966935984478107*^9, {3.9669419000436783`*^9, 3.96694190568858*^9}},
 CellLabel->
  "In[418]:=",ExpressionUUID->"dcca2421-dec3-4bf2-825e-598029a4f6a4"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwVl3c8Vf8fx60iIvcaZV3zmhWJSqnP22igiUohIinJ+poRETJKkmQkZYWM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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJwVl3c8Vf8fx60iIvcaZV3zmhWJSqnP22igiUohIinJ+poRETJKkmQkZYWM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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 4 Pi}, {-0.31753560840750816`, 
             0.6964440908700368}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{0, 4 Pi}, {-0.31753560840750816`, 
            0.6964440908700368}}, "Frame" -> {{False, False}, {False, False}},
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
          GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.24, 0.6, 0.8], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwVl3c8Vf8fx60iIvcaZV3zmhWJSqnP22igiUohIinJ+poRETJKkmQkZYWM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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{0, 4 Pi}, {-0.31753560840750816`, 
         0.6964440908700368}}, "Frame" -> {{False, False}, {False, False}}, 
       "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
       "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
       GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotInteractivity:>True,
  PlotRange->
   NCache[{{0, 4 Pi}, {-0.31753560840750816`, 0.6964440908700368}}, {{
     0, 12.566370614359172`}, {-0.31753560840750816`, 0.6964440908700368}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.9669341828255243`*^9, 3.96693438207159*^9, 
  3.966935985101687*^9, 3.9669368854912357`*^9, 3.966941916170808*^9},
 CellLabel->
  "Out[418]=",ExpressionUUID->"cf182957-0a69-4fee-a482-919a3afaf700"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.966941916193548*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"75020025-4735-4b9e-93c0-799f24d66636"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.9669419161942263`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"1e2c9bf0-2936-4e95-b7be-022d2a2a9bcb"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.966941916195098*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"5299accc-a4d9-4007-82ca-23783aa0dd1d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.9669419161955957`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"85a86cba-335b-40fd-9d85-231631678934"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.966941916196087*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"14060e0c-d233-4295-bc81-a13027c94470"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.966941916287821*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"92e73d63-c6ca-4597-bf28-55032b1e73ec"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.966941917294985*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"48b02ef9-353f-4c46-ae8f-d6bd526e4e1f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/plot1/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/plot1/"],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.9669419173000517`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"cc51a8fe-ee80-4a1f-8ca6-3564dd8c74a4"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"plot1\"\>"}],
  SequenceForm["Archivo: ", "plot1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.966941917302911*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"e64c9493-b855-4c42-abd0-36ec218cede4"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.966941918168256*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"b8c97177-3e37-475c-a2d9-2a504af7d67f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/plot1/plot1.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/plot1/plot1.pdf"],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.966934382072613*^9, 3.966935985128401*^9, 
  3.966936885517969*^9, 3.966941918169086*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[418]:=",ExpressionUUID->"5f52edf8-7925-4dff-a11d-cc751188f46a"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/plot1/plot1.pdf\"\>"]\
, "Output",
 CellChangeTimes->{3.9669341828255243`*^9, 3.96693438207159*^9, 
  3.966935985101687*^9, 3.9669368854912357`*^9, 3.966941918181863*^9},
 CellLabel->
  "Out[420]=",ExpressionUUID->"9d85250f-90d5-4874-b768-d4dc635c5db3"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 2: uso b\[AAcute]sico (empleo de textos)", "Subsection",
 CellChangeTimes->{{3.966934422662491*^9, 3.966934426488489*^9}, {
   3.96693647794874*^9, 3.966936483034643*^9}, {3.966936588520303*^9, 
   3.966936592206142*^9}, 3.966949462166122*^9, {3.966954072623766*^9, 
   3.9669540801837873`*^9}},ExpressionUUID->"497f939c-3a58-47f5-a324-\
e93699411202"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plot2", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "\[Pi]"}]}], "}"}], ",", 
    RowBox[{"PlotLabel", "->", "\"\<Funci\[OAcute]n Seno\>\""}], ",", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<\[CapitalAAcute]ngulo \[Theta]\>\"", 
       ",", "\"\<Amplitud\>\""}], "}"}]}], ",", 
    RowBox[{"Epilog", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Text", "[", 
        RowBox[{"\"\<M\[AAcute]ximo\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"\[Pi]", "/", "2"}], ",", "1.1"}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<M\[IAcute]nimo\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"3", 
            RowBox[{"\[Pi]", "/", "2"}]}], ",", 
           RowBox[{"-", "1.1"}]}], "}"}]}], "]"}], ",", 
       RowBox[{"Text", "[", 
        RowBox[{"\"\<f(x) = sin(x)\>\"", ",", 
         RowBox[{"{", 
          RowBox[{"\[Pi]", ",", "0.5"}], "}"}]}], "]"}]}], "}"}]}]}], 
   "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"plot2", ",", "\"\<plot2.tex\>\""}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.966953993377236*^9, 3.966953993817276*^9}, {
   3.966954083935219*^9, 3.966954099972459*^9}, 3.967190367042696*^9},
 CellLabel->"In[4]:=",ExpressionUUID->"76f18160-8686-4ef3-a9a4-8b46a8b0a07c"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwlmXk4lN/7x61ZUmaeISRF+0pKaaH7VEKRUqJFSFpIEhGSSiUk2SvZUpb4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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJwlmXk4lN/7x61ZUmaeISRF+0pKaaH7VEKRUqJFSFpIEhGSSiUk2SvZUpb4
RHZJTpSikKiEopAsM/NYx8xk+Z3v9fvrXK/rmvMs7/f7vu/zXKNhf27fCTER
EZFsURGR/63iWLauc921Lbyy/18X9ZZtnhtpC/cKmobnkFX4XMuhOeIcnI/O
N/hC1j8Kp/mFEVfg6tNyn2SythjeqEiJuAtq15Jq9pP1q23EkviIRFi/Y4bF
gfBE2Oes0nI/IhvWYeEr7zvZED5knRcTgWGD4lMDNT8Mmyt3yW5zr4ebpa92
yO6oB1cfs2N5rt+h6OIbndLmJjhbfCJUbMEvWJw595Mxuw2+9OyUSbPvgq7u
5kOV0p0QrMUTKTzUAxpSGaK7mN1wfkVV9OsUNgjd36/L5PdA14muq0mFbDjv
WbxgnXgvWCaJOF99z4bnV2eoFc/ohU2KG7ehXjY02Oksfjq/F8SmnnLxSg5s
7521Vde0FyIabhvhPA4cP5WsIJrQC7neewSvyrlg1tzkoavXB8LjZ7J+ugzA
f7N66u7Z94Mdc9ir1HMASqeOzHvh1A+VZT7bH/oNQKRDZG2jWz+EqQR/Pxg6
AC9MPDeP+vfDkk/pYl+eDcB6s+DFPcn9YLGp2/IDewByji+6HfK7H7IYx6YK
nQZBJcbibMUhNiiU9VRHuw1CSrlY9fRjbPA+4xp1wWcQTH60GJqdZoPBuyvL
1gQPgnujeHKZJxtaLyXsf/Z0EO7muqWYRrJB+m9r2uOeQfhoMNNuzkc22L+y
3Bt2cggCDmCe3zoOrClUplTODYEbb0Gwux4HxLJbGh9dHALv+atrbLdzIDnJ
xiovcAhWPbKzmGfOgY7rJ22+ZQyBbnL4lk3OHLDf5ek8hx6C1xt8a38mEW6K
Dky/OAyMM5s4deJcWFNvtUv76jAc7WrKLZDhgli1ilxJ4DAEOhSxI+W5kFwS
f/fjg2HoPRJeuF6VCx3xKTHcl8NglX/7guIaLtg7FDzRERmB329cV6+34cLx
wS+vXweOgKO/Y7sgmwt2PmFWxWEj0JY757hPPhesxU252fdHwFO3dudwMRcs
Fd+oJqaPQGhc8eY64qPxxhzPy1Uj0G60IHJpIxc0r91ZuUl6FGQmPmu4jHBh
uezON9qMUVCLdba4wOfCkkiJw8uUR+Ft8bJmt3EuqKdcuqW8dBTugNLXgxI0
sKodO3hGo7AlzPdSFYsGPsPwft6tUVifGZe1TpuGkQeiWpl3R6H9Y17Yax0a
Bue/qky+Nwr+osKC7Rto6NPRGQ5PG4Xi+gfv1gANPw/ON3N9Pwqiwfo9eaY0
VCRNiq+S4gGXrXxh60kaypaVxC6U50G1x5eFex1peJnroT1HiQec8sLpVs40
5L9l20xfwgNactBrtxsNaT0tL3oNeXB/QW7pj8s0hKwuOpcawIMjWudMbkTS
8GFNU7dHKA8GdyavkImhQXrd2NEdMTwwZovcDLhPw42NuqZdKeT6rM4kp3ga
Lm0rWjq/kgejV+XPfk+lodigKXGwhgf72k5O03hKA89wbFb5Fx7MkD6qYJ9J
g5uJrqRdFw9aboqG1GbT4GRR9DtefAze7Ypo3VlMQ7pl08Gz08dgVcym6ZYl
NHQfHPukxxqDMpHTmYdLaTh2VLesdf4YNESc2rz7NQ0HTxbFqmwbAwfdkZCm
9zQYeRXtj746BjrzxKOufiXP69P0wSFwDFac3hTDaiL6+Y5t1Qkbg6JINbHE
7zRsuaa7ujFxDJ77uComttKwPrhIjonH4PUyZ3WD3zRcCGm6/uvdGKRcUzkZ
20FDbuiYMLtuDFZH51G9nTSsitTtNWsbA3aZa+K5bhoWxhVVhkyMQf76Kj+N
fhrsE5r0rCX5cL351vAmNg1JSWN5K2bwYdZAT40ph4Y5KbrJH+bwIXdbyH+H
aBoOp1mpxC7kg7qzea7FAA33n14Mc1zJh01dr1SNB0m+sor8pPX40HwnVVl5
mIa9z5tGm7bzYUAzP3OEcGjumHOaCR+GJ24/qh6hQbZI94jhET7UCerzrXk0
GL+walA8zofps9s+zx6jIeDlxZ1/nMjz7Bnd+5mw2Osi3Rs+fDD/Gn1hiYCG
jBlU6oQ/H0Ikfu/9QnjfEWeFi7f58DO9ScdLSIMw/Z3/QCQfwqtM1Fn/aHjM
Ux90jOODFpfJSiFsanDJtvMJHwKWis7QHCf5D/9aa/2MDwWywzOyCBusCs7Y
U8aHiXTzhZETNLB9upSr3/HBTMNvI59wVNWWW9s+8WH8xcoDFpM06M16MPqy
iQ9WcdsvphH+c3z4+LpffFjvmZk4SDg0Z3dDVg8fprz31K2ZIn5OpaGlg3x4
ZqMmfoZwm6lY9iMBHxptJbfEEg6ItVZTFRNAir7Q7zVhzZ7C21GyAhjTG6z8
SfjbOqZwBksA25d0UEOE/a6fOX1LVQAZu96fmCC85HPlN5GFAhjxji+bIlw/
V32Hz0oBRMs5qAkIezn75A3rCCCzbY5/L2H1ki8aZ/UFML63hl1PuEpKK6x7
hwB4xt5Hswm7HgiatDUTQPbqVV9uEFZ+3OncbCmAdt7wXnPCrwf0W/fZEp75
o1GBsOOW+ztrTgngsSvP+hN5fypkqGiHqwBe3LdkXyVc0my6GHsJYEsg5b+M
sP2StKgN1wTw4+22udVEX1kPUfHcIAFUHBQrtyWcW3Hk/IoIASQ0uDhxiD+H
GYXtT2IFcHdH+mw3wmI2DLO5jwWwYOfnzxzib2amU+m9TAGYCGaG2RG2ELxd
zswXwG5e4IEPJB/jhvMeBJcK4JWD4/wVhE07Gj0u1wrgwiuq8TOf5EFLs4v3
lbz/Tb0iJcJxlwP3ubYJAPmGPrYgeeQo62sdpwVw5UhgdN4o8XdPao8xU0jm
j8sfySHib7yIVYWKEDLH7JkSpD7a+g5Xbp4vhGO5l4wEpJ60AuSTNdcKgdYx
bqwi9VZf6nVE4YAQ6kxU3cZ7iD+yjdV3jgpBXZoey/1L/Dm4aoPUSSFo6d8I
tiP17Dr8W0HoKQRxi/NNSaTemctN6trvC2FPlKVq4U/Sn6QSmVVJQug/66aF
fhC9/wxZPE8XQkKk76WKFhocHsW2Xi0WQm54Q2k26T/Fyn09Gt+FcOSYFr3y
Mw13ePorZX8JgWF5uNbrE/HnS/i5ob9CWBIT0V1aS8P0sI28ijEhcIPaPq76
QIONVJC4g9I/YJ/XdcmtoGHtnx+GpvP+gWcGpf2a9EPpN6uDdZb8g7qEyDXv
yoifft8Zkrr/oHXEc7iE9FNJ3pK5qZb/QGqwzMcol4b/ut5t6In+B8XCE4qc
RBquVcz2rY//B5/9skSukP5umeSCi1P+Qa3sxrUyD2kQsZ5lGFTwDypOXnad
RubD/sYT+5d//QcfB+SOPrlN+kG5hIuzwjgk8SpCXTxIv0nc9nggYhzeBcpt
3rqdhltV9T/9H45DsarHoigy394N2igrPiG/37FauW0zDTsMLt3ZWDAO8651
zrYi83Fbb95F/6Zx+HkjJ+/nQlL/axeZKsyZgMygMc0tZN6ufi81qpsyAddi
OnMtSrlwbiBa68OzCYDnN3uDi7iQpbLQybpwAt5a3dhTnMuFVc6o/er7CZCR
XZDNTyfzneldXd07AYV3dnTJR3Nh4ZG++COak+CceczxwRkuKNE1hleKJqFC
ssN3AcWF++H4WC+ehNBrxko2clxQ1sn13V81CS/TltmHTSPsfS93SfMknOms
lv8h5MBscfu59cJJWKUlwZfv5MBcpbFR9S1TMNoxfK4/hwOLQSOl4u0UpHqN
MS/v5EDs+xJRcUcRdETh1yJ3OzYM/HruTTuLIPvncema5PxnJEwdbHUVQScz
Yg91mrNhZGXk73wvEbRQ7djuDdvZYBZxpvxkoAhSdE56FraIDWJH51z7kCaC
ShoCOsZ7+uHM0GWRiG4R5NskIlJPzqd6alun1B1EUf2twEO1h/vA2PqLm/1p
UfS9/U23hnkfWDw81f3YWRQdFtwUPWfUB2dUQmsXe4iitn+xfUNr+yBWsfXh
ygBR9Kn4xPdHcn3An+GxYUO6KLpUZhiVUNoL+ZPp5/ewRdGtCMPAJUq9sOIX
o+vyBTF0SHe4S63oLzxLp04XuIkjOZ7UJ9f2LvBtO9q4IkAC/dx3Ytl1l99w
Xm+DSUKUJPKtN4pa69cKwkQD+/6waail2/RRleYXqHeNtbuYLIXmynkvdfvy
HjYazZ/8+Ugaff4md3JS5DlU79iYjuJk0MZ6m7nZIVk4JefBxo5MWVTPUtdL
uViFFResdLJ5Oh1ZLMldaPinETeISvurlMoh8Q+JT3VaWnGBtHtqffUMFOW9
uuBNzG+8UpHhZF85E60Ie3zQ+mUXpkN5Cmu/ySOtO8zOxdV/MXtgbsWqFnlk
mPimpLrxL+7bZ3RuaZs8qqT3PzvZ9hd3zbpfrdZNePzu99Dhv7glYaOfNE8e
bYownbyn1oPtrcqGubIMpL7cfttt1x68+5To0bfLGWh7vENTJ7MXL7h1S+uc
EwPJVFv6N27tw27fdPzsnRlofaF47Mtdffj1oo6aAy4MtLTt5Pn4/X3Y5q2e
k54bA4W3tlmanejDsaJDT2R8GOhM/+dyh8A+TPlaz34SxEBeZmGG9rV9WOy8
tmRzOgM5HhuvD9/Xj81ft+2vyWCgVUGKf54d7sdJ8iHJ+D8G8o3R83pj34+3
ZHVD6nMG+pEjqdDq1o99+h/6uBczUNBfFvtlRD8eOjFtYEYVA9V/Krm47XM/
7jjc2rLtLwNp79g6x3InG8vpW6XZ9TJQwqvWT3rmbLxuXqO7Xz8DcWbKx6ge
YuPAzg9yJTQDzbZ0My8/zcZaziVbtPkM5FQ0zejZLTb2vfwgeZ4ME2XYRZpI
vmVjxSQrp/HlTLRPOkQjbT0Hb/FvXD97FRO9OtUwM0Sfg0877BHfoMVEhkuD
a04bcHDpUqM497VMpNeXlCOzj4Ptc9bX9W1mojf12pweZw7OqlBc02zKRBrq
ybdUH3Gw8Z9GQYELE3UtMM0xEOfiyytCL2W7MpFRadTwS2kuzj1vPJHuxkSX
w9W7VszkYtXJUpE4TyZ63174YVSZi7mzUqX8/ZhoMkwnSFuTi6OMvRTNQpmo
YZX0f0ZWXPwrc4529zMmqk2UZ/95zMWKQ99y27OZaM1zw0DXdC7etSFcpzmH
iVIvfM0c/o+L895KbqgpYKKsP9E3Ogu4OOAnd0vuKyZawTCxcXxPPmXly039
aplIkFddKdfLxV5uJ07P4jDR/mR728zFNA404Z7aRDPR1urV0yKW0/jewoun
bAaZ6BRb7PU5TRoXfgs8mTrKRMH9RqcZ62k8vOk/h/WTTNTpPurcbUBjF/Fh
O0t5CoU4mlp32dH48o9Ldj5MCi0em5W/2YHGIQUSdgksChn+PTYz+BSNM0/N
su1WohDFy3k33YXGPR83HvVUpxDH5PDKxz40Ph519VCMNoUYciCpEUFjt7My
h0rWUqj3nqJKTxSN/Q0jDrato9CBiUsaqfdonMR/bLV4E4Ui877JScXTuM36
/YHCbRRaEOK4wTqNxpx1ew+0GFAo0X9fa8tTGo/PbLaYNKTQ5ksfnff+R2PV
8r79hiYUOvct4aB6Do0PLpq579t+Cmm6F6L9JTQ+PRljLjxAoeAQvkFQKY0v
Ns0zn3uQQsskz68pLKNxTJD23pPWFFrxPOjdSAWNGzkWZjwHCjnKhFRIfKSx
WeHDXbM8KbRJdfj2uWZyvWH7KUUvCm2Te7iX30Lj66uX5yv6UEhvtFXd+weN
izOK1RT9KORmmtFh307j+YlfB1gBFFqU4v77WxeN9X7EpbACiV7i9fx53TS2
UnE4zAqmkN22ceVjf4nekUNvqFAKvXxw0+1jL415t+TvMWMoxMIsf8SlMaPy
mwnzPtm/+UHTTprGK8QSRJixxI/aJ2tNBmhs57vSiZFAoScqeybXDdHY58Xw
XEYShTwM3Z3nDdM4mlfSKJ9M2GnpL5ERGn9w3akvn0qhBIeTTZmjNO56xhia
mU4hi7gbhz14NJ7qa0qdmUH0DbXpWD9GY50TJxkzsyg0xzxg6hGf6JO8qnLG
c3J/D+8oEwGNHdtHvGfkUshI6LaKQzjh0PVOuUIKnXrV7KT8j+gTs+u+XDGF
hreOz0wm3NjI3C1XQiGFgruFC8ZpzGU0i8qVUsil0P1YPGFps6TC6WUUWtcV
JC8/QfS8ferM9NcU2tJa8NqLsH6Vpvr0CgqJ6/680EL4oCTvi+xbCqWF/12h
M0nyt+1VkOw7Ck1cL/tzk3DIlRtbZKsoFJGyO5mct3FaqcmwzAcK/Rfif4w5
ReMKAZUuU0OhfXWmC0wI/1jfYi1TR6G9k/F/fQnz3B8xZeoptDHbMSuVMDPn
9DvpBgqddSPTiPBKrtYl6S8UUvpuvL2DsOGKMS3pbxRae243c4Sw3emyLqnv
FAqrzPpNvj/wpZSbD6RaKFR3yimffH/gmA5TM6kfJA+/rwSR7w/8fJ6CuFQb
qc/SAbt+wh+sW4um/SL383+96SvhPw+Snad1kDyUjMwqIizS5KgxrYtC1eyo
0TDCsxW0v0l2k/3xGd/sCeuY84Mleyh0x3xryUrCe0IxSPaR/bdPJnGJHk4f
A0Yk2ESfumVB6YRvSJs9leBSaEls3IXDhBN2KNpIDFCI6dJgL0H4hf8PSmKI
Querfu1PJfpzx518xXkUChX7u6WB+HfooMkywRiFztiLxNsQfpu34htXQKGm
ytLdncT/B05srZYJCok0xKR9FdJY4l3Nj09TJD9rR/duJ+yi8SyoUpSFNGS8
dj8leTL4frbzuSQL+by/imxI/rLXmoWlSrGQxSJL3Wckn7PvaurHybCQXQf3
2gjJ78AOOubWDBaanqbGcib5fpjnustGkXDuq+VTgzSeJm8+tl+JhQ75ct8y
CLs6aT/ZqcJCYz+98meTejLUGJrQUWOhZ5cCo5RI/Q2FuudMX8RCnoW+tgWk
Po/27bcRXcJC77mWmUE9NK7aoTN9bCkLJZTEmFmSeo4fH3HoWEn2C8/FfSf1
b+zkqfxCh4Wyb860uUb6Q16lZWXWehbidN05q9xG47kaum5PNrBQqNfItzTS
T4abxj7e1WMh/aGW4uzm/+nvfeWkAQsV9a56c7yRxjKPDq20NmShno/CzFef
aXxhfGOzuTELXRVNHZSvp/HOPOEafVMWMqlbFx1fQ+MRdd9ulgULzbbhGR+t
pLGtr3WkjCUL5Xs4LPR5Q/LVpIemrIiee9Xs7pbTODF04kHfERbavcdYmPyK
xrvG/XaXH2ehpX++v3MpoPGjpmv5Lu4sFDP7rvaDxzTurlzdHurBQkJUWCT9
iNRDfrtM9kUWmgEGe84lkHkUpm9LX2Khm+yAAo0HNK7ZKZBxvcFCG20a3VVD
acx/6Wp7Pppc31zT8bgnjbdkzAsOv8dCWrWHjxu4k357vy4/5wHxt77l0hxX
Gs/0WCk7FM9CXkGnp+c60niBZk++WyoLXe43LXOzJv0pyVb2QhELKYiLGpsg
GkeFzlwX9YKFWswa7iXo0bjZ95Vt/ksWqm06odi7gcYOh1QLRjALTWVNSziu
TWNvqsnWo4qFAtaoi9MaNH5yw6zAs5mFutm2CnaiNBae1rfz/sdCDbXBEXkv
yHx/uRx5TLDQm5yMa4jM84czlNXPT7GQ81nJzsrnXKyXO9R+WlwBNfp9FSlJ
42K/f2m2B6crIM5lzSqjaC4WD6VsdVUV0LNskwChCxfL5f09OrpJAZX/d2BR
5Rwutpb8qj+op4C218xNtlfi4mdWFWqcLQqoluIX8ZlcbDYe97NrmwKKjVid
P1OKi8N27Dv6ZZcCSkvwUOgY4GCF76XWeYcVUE/VovQlbzhYbSL8yHkfwn9j
VTbYk/NRx+4X93wVUEddnpbDEQ6+8F5GqcxPARUONHy4ZcHBH8KvNcheV0Az
G1n3Cww52HPx+Z1Pbiugn9eL32Uu5+D6PXt1m+IU0DUJc32JQTb2T57J0scK
qKVY8cCFi2zcbXT7g7SEIrK25az9dKYf25vYqS+apoiu7PTRVjrej3+arfPc
Kq2IxgW/Q63IefXLgXYNHzlF9EdLzL3cuB9XHF/r3a9AWAkt2rSoH8dfaV1S
t0gR7R1xsSn/0YctilbcjDRSREn1R8Y2GPbhN4trYO5tRdR0/K2GvXgvdpJO
ldCQmYU8d8juqrXtxkVJC/XfhM9CUq9WOZVqdOK6zXqV+5hKKMCtpPLNvXbM
d3q43y5UCWkVWZS8j/yOq/YmHpgxSxlNtH1/rx5aj+036qWlRSmjh57W6Wpx
5diRUzv6I0YZlUraaapZlmPXR7YG1ANlVNP78YwSoxxfkbn+2zdeGbGmbbYf
v/4axzVXq+5LVUZBF94uVmwqw9+8rcLGi5RRY88sz2j3EryrxM3bvFUZNTgn
zPiVmoPNXSSqAn4qo43fm1rbVXLwwfkxs0rbldGC61/dW0Ke41PBL/IWdymj
4/7U4Wt/svCNwyLcf2xlVOWjOZDpm4HLhHfsUyeVkefT6MWRTx/hyqx5Oa0i
KojndM5U4W4SrrHPmWKIq6DWsPwa9d4E3PrhS9wlKRX02ehB/KhfLObHqjbt
ZaigX9sTS7ZnhOMps2eLAigV5LB412ZGXyieJg4XXiqooDXD9tF3rwRjhTP2
zMUqZP/Xv6cuZlzDqvNGbI+oqqCFVPv8yis+eH7jzawwNRX0ItXDPjLjPF5+
S2micp4K0o07e6U44xjW3vzU5J8G+b32nf/9v1X2f6Bq2XA=
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 2 Pi}, {-0.9999998592131705, 
             0.9999998782112116}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{0, 2 Pi}, {-0.9999998592131705, 
            0.9999998782112116}}, "Frame" -> {{False, False}, {False, False}},
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
          GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.24, 0.6, 0.8], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwlmXk4lN/7x61ZUmaeISRF+0pKaaH7VEKRUqJFSFpIEhGSSiUk2SvZUpb4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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"\[CapitalAAcute]ngulo \[Theta]\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"Amplitud\"", HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    InsetBox[
     FormBox["\"M\[AAcute]ximo\"", TraditionalForm], 
     NCache[{Rational[1, 2] Pi, 1.1}, {1.5707963267948966`, 1.1}]], 
    InsetBox[
     FormBox["\"M\[IAcute]nimo\"", TraditionalForm], 
     NCache[{Rational[3, 2] Pi, -1.1}, {4.71238898038469, -1.1}]], 
    InsetBox[
     FormBox["\"f(x) = sin(x)\"", TraditionalForm], 
     NCache[{Pi, 0.5}, {3.141592653589793, 0.5}]]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotInteractivity:>True,
  PlotLabel->FormBox["\"Funci\[OAcute]n Seno\"", TraditionalForm],
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.9999998592131705, 0.9999998782112116}}, {{
     0, 6.283185307179586}, {-0.9999998592131705, 0.9999998782112116}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.966954105031747*^9, 3.967190369632759*^9},
 CellLabel->"Out[4]=",ExpressionUUID->"a60d98d8-013d-5e48-b397-e876b5ab6f62"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 3 \
elementos\"\>"], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.9671903696845417`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"16b2f3b9-69c2-684e-a982-869308a9e002"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "2",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 2, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.9671903696873703`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"25ffe185-f2e2-0542-9352-e76cc8b1efda"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.967190369689371*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"b6dfa168-d4d1-de48-a314-839d1142da18"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"C:\\\\Users\\\\enrvq\\\\AppData\\\\Local\\\\Programs\\\\MiKTeX\\\\miktex\
\\\\bin\\\\x64\\\\pdflatex.exe\"\>"}],
  SequenceForm[
  "pdflatex encontrado: ", 
   "C:\\Users\\enrvq\\AppData\\Local\\Programs\\MiKTeX\\miktex\\bin\\x64\\\
pdflatex.exe"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.9671903697586727`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"f428e4ca-b060-d941-adae-4df3fab2924e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.967190369761072*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"7f3bdacc-9b9c-5646-9107-f604e1b9ba12"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.9671903697633305`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"5ec9d25b-d372-3b4f-8da9-df28138a3d06"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.967190369820385*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"2fb99248-4de6-e14d-97e4-f2900085ab2c"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.967190370790653*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"abb1ce14-004e-ea4a-895d-d9ded8001f7f"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\Users\\\\enrvq\\\\Downloads\\\\plot2\\\\\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "C:\\Users\\enrvq\\Downloads\\plot2\\"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.9671903707946625`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"3e193277-3bfb-824b-bb7d-3b4a2fa03a9a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"plot2\"\>"}],
  SequenceForm["Archivo: ", "plot2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.9671903707976685`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"c56abf5c-d8ed-d44c-8284-12266a3b11a9"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.967190372396147*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"fe12a0c3-c509-d340-b50a-70340d4bec04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"C:\\\\Users\\\\enrvq\\\\Downloads\\\\plot2\\\\plot2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "C:\\Users\\enrvq\\Downloads\\plot2\\plot2.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{3.96695399519702*^9, 3.966954103167198*^9, 
  3.9671903723981495`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[4]:=",ExpressionUUID->"7a9cdd38-8a78-4047-ac01-fcab057f532b"]
}, Open  ]],

Cell[BoxData["\<\"C:\\\\Users\\\\enrvq\\\\Downloads\\\\plot2\\\\plot2.pdf\"\>\
"], "Output",
 CellChangeTimes->{3.966954105031747*^9, 3.9671903724145527`*^9},
 CellLabel->"Out[6]=",ExpressionUUID->"6f6923a1-4043-f147-b596-d8f9bff35370"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 3: uso b\[AAcute]sico (empleo de textos)", "Subsection",
 CellChangeTimes->{{3.966934414067052*^9, 3.966934416273943*^9}, {
   3.9669364883894033`*^9, 3.966936491765872*^9}, {3.966949405539422*^9, 
   3.966949414656761*^9}, 
   3.9669541141868353`*^9},ExpressionUUID->"e850da31-64b4-400e-b459-\
a4be2c49be67"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plot3", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"x", "^", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "2"}], "}"}], ",", 
    RowBox[{"Epilog", "->", 
     RowBox[{"{", 
      RowBox[{"Text", "[", 
       RowBox[{
        RowBox[{"Style", "[", 
         RowBox[{"\"\<f(x) = x^2\>\"", ",", "14", ",", "Bold", ",", "Red"}], 
         "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"1", ",", "1"}], "}"}]}], "]"}], "}"}]}], ",", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<x\>\"", ",", "\"\<y\>\""}], "}"}]}], ",", 
    RowBox[{"ImageSize", "->", "400"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{
   "plot3", ",", "\"\<plot3.tex\>\"", ",", "True", ",", "\"\<black\>\"", ",", 
    "True", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Ejemplo de texto\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2.5"}], "}"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966949373849395*^9, 3.96694945136705*^9}, {
   3.966954117208766*^9, 3.96695412227306*^9}, 3.966954153138928*^9, 
   3.9671903936119747`*^9},
 CellLabel->"In[7]:=",ExpressionUUID->"0120dae9-4ad1-4855-9221-b449d14d2d9d"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJw1mOc71n3cgO3NhZu6FTJKVlYoFZ+fkqQQmZFVKEqyZYaErJAdslUuO9vX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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJw1mOc71n3cgO3NhZu6FTJKVlYoFZ+fkqQQmZFVKEqyZYaErJAdslUuO9vX
3ntvIiMrMkK4nvs5jud5df4D5/nm5DZ9oWFGQkRExExMRPS/FIETywQCAVl5
CA8QCDjsxT6v//4BAWl+Ux3b2sFheYXifFs7BOSQb2P/cwWHSfCrmC6sEJDp
ZuHj0WEcdonJd6xjmICWoy9JdeTiMGxusy02l4BSPC9GHRnhMI23nV8uGhFQ
ZdmRTmgtA+bU7fvcovoYfRwZH7MOoMcGBmiXa02OkN4LC/YHBzQYR80Llkvs
h4iRx0/BJZ8KK7ZqIMdNHiDP+Xkv0WAKzDhIfGPUex99UByNfqdNhu2Fu/oj
2ENhgg/vcBqTYKkMU2wx33dRMt29AAsDIixBWdy2P2AHHSjm3rE+PgTvZybO
Are3UY1v6yXp0n1wJf3sZLv2G0m8DjQif7wLJl7dZ4eyNpEezuZzpfsWfKia
j0mw3EAvaArCCcMbUD7NT/eVZx2xuJPy85usAi8jdl0zcQVJipWGyQ4tQoGg
v+Xs3BLC4bVeCRrMwXRjPpe09AJizDl82zE4BfPCHyTQtzmUOdBpeEF5BJg8
sqVFiL8jDjd7ZW/mPvD7xt/C+GcGCWz4ZVAd9cLBeqbe1uoMkl+L7Yhf7IVZ
owy30pEZlORd67hU2QsF8ql11/NmEN2pkzdOP+kFDfKPqjpGMyj/73jFQk0P
nGfj7iRynUb3WGL1Bfe6QFj6l3D61gRyzHzPlyzeBuYinp5lkxOIYdl7jYym
DZL4cH2dzROoY+Nz5dvZVmA+Keq0Gz+BkHKS3WJEK/z5Y117S2ECuYmxKeD2
WqCubF1rOXIc6darvyBqagZd2XUPUekx9J5iaP2JcyOES3n03uAaQyxdSZUh
mo3QfoHhrC7NGKrSSw7vE2sEOU6RVq+pUeRXdVOn6GcD8BKe/9PnN4p+feO+
MWPQAOs1a5n2wyOI5yVn+qhSPfgorPWUOQ8jGlKhcI1LtVCntKom+WgYcRcu
VnedrAUilZUuvMowendgM2WxVwNuWj87UnmGkYnaz52NshpwNJ9vCe4YQjim
l36GcjXwxH+yxoRrCPUvlemrxlbD3Y7OPOqWAXTV8a7w5FE5BPZ0iPoWDKCK
LyuXmZvKoWWgHX+cMIAWcGeFXoeUw83J1q9bLwcQ9ti4ho6rHOTWG7MmTw+g
X9co8WM3y0CMsTo5/0U/UsPTR6knlACrJj5M72QfYnp/FPPFvggK+N6V3yTt
Q/hVhtCHt4rg3r7FD/FfvajyvNeS/KkiCEzkvkzT3IvYr3k3fqophOOlyOly
x15EOkXGX40rhAV3VxH2oR5kRUEW+rQkH6zV3sdUCXQjlf7+VlY9PGRtK69+
IO5GRObrwcy0eJiNJcOsR7tQSEnLv/ZVOaD9w2mRM6ALQXSltxlvDoCLobTX
UifaUPqUSbz9BRhThQauZ3agNw6GUmeysqFgtxHXcrYNeW5lGv/ST4eQzyl1
cvutqE9B9SklazpYGXo6FHe2InXr4KUPXWlwtunyeIpjK2q7PaR84kYaRH34
kuHe0oJyecIT08RT4ZXke9mLz5rRLYMC7z9nP4H20vONbKz5v54Wth3nk+Fi
gnIqF2szUpkomHyWkQyrpGTUDNVNaL/yxD+VAslg2O84sIRrQoEY06keq0S4
bmtglVjYgDQnBVxXW+KAk0+Gk9W/AZkGfpUo142Dv6Osve8MGlDTovGw/c9Y
KJLvlnYhb0B+hYZLefSxwMd0nURTpx6thOD5FUyigSbvfCz131qkppXEMywZ
Cenj88E/fasRiXzgn4eng2HM7UTSx4vVaDm9qv3U6yBg4LyVpz5bhaT0hQrs
l96Bo3FWXxlUoT/fiosJFYGgOG95MvCgAold9Iu2dfSHpfVfyYI2ZchW7kRT
+2VfYA/jKpjiLEMfs9er9Ep94J64en14Zym6YEbc4ivjA6V2BfMHgqXIpXOQ
uQDzhoA9e8H2+W+oyfSKz1NTLxAkOSi00i9CD7D5j9ELLmCYKth4hqYIXeGd
GdBic4FwBf2h/tJCNJehJqaq5gwHfpV7V08UopCwIM21Bkdop/WUpevNR6pr
7hrzQ3ZAlJOrWuOZjxyHOHLsee1AUnXGyF4kHz0ylhCWs7OFhDB574l3eShG
uyzak/0ljAhShegF41FfjLuSs9BzwJ4/zatdzkEZTpQ3ZfasICu3rU9AKQfR
xrwKtG63BBfJ4JMHJF9R4Ef2Dak3T+CUHPOnOOdspFWhxndZ8TF4e9nVkwxl
oYIMXst4xUewUjcwb3kxC6X0z+zaqphC5a1owavrGUjy94kVD2tjeKjOXjT+
KA0p+/5wYznUg9WtHRmHhlSURY9LJ3mmC25R3YjhXCo6V907rrukDQnj3u3y
C5+QS+QZB1kKTRD2MFAfV/yE1Mo/D7dnakAFl/SwfWYykqfsUqrTUoei9r5G
td5EdCxcntOVowIDjH693uEfUXT++0UhzTuwpSUzWXw/AT31jZXT++c2SMwk
bZ8eikW1LFcUzk4ogPq5+0Rq0TFIoa/vd+38dbCxpKDz1o3+r+f4alEqecjd
fsa7NBaJLGrc9f+IXIUuGS7R0wkRSClHPKWQ6jKse/RfUX0Yjj5JK/IyskgB
fYOf4mvO9+iFQcUUnboE6DLbpz1BochMlif7vqcoRCeMVXTJB6PxgxDqLiQI
Q3zy/ZINgUhus3LK/xEfsORnLscp+qN3XF/5fS154P5VBhLi1jcohKmsyzOb
A8Ib7dks7vig6fsJUs4KJ6FHbVyss9MLUVCR+G2mMwFnkU+YebIbYjYY8ByO
p4b4lntIIt0JtbzLbup0JoZ/JznWj7NtkbEcZe27xh05oblBmaiHVkhUL1CK
YL4ox0dnEy1iYYLa/S9aTqz1yXkN8A+crldBtxfaaZXwX+SEcZOW5Bck4U9U
qgzdSxe5oU3vJMY9XSBz3dmId62X21A7//uFrTnI0EjrLrhPy7lGKLZZSdoA
DweFps/TDbljD5f4JFEHOOVJVRpGfyjnZfn1Wb/gK7iiSfO9x4wcSLWnZSn5
PCH+LqvMuDoD1HMFvP3I6A26kcwFdmYs4BvFY3MpxBdkttnzXz05BYp0lbq9
tG/h7+zAXeJYLqD01pK3CgiAJt+JYnKTs9DyZ12AnDII3IzSI5SD+CHwuT9z
km8IcNuJLnSfugAZm2Hu7K/DYNSoakiZQhwsLATNvx2HQ8drQZXNIGlQ4nF6
4CMbCc5Hm9NFcTLAP1mves/tA0Sznsr5d+waLGs8vLS8Hw1J9IquM7vy0Eb/
WajkciwYk1mVkXy/AV9ads/4OsWB4e0alp25m/BMLoyKcycBaKr/8ihLKoPK
/sTh8sVEKFv7Pvj19V0QKRLYLLFNglSrvfTpRVXYi/y+yr+XDKwC410PCOpQ
RuM6WOeQCoc/yh2YvuhA8gXW/lyeNDAV864j0dEDv3u5PQndaRC6qbofzKQP
mlFz7Y4CGaAyuHfWtsAQNrjv1glOZgEX063yUvVHMKywgE4GZsPf4BoqNtPH
UG3hVUV26TNUNl672+RiBu9yikqnwr7ATzPZAkpkAXwyHLnhCnggfWp0cO7T
M6AzKPnquYkH8qr1jbWV57Dlof75WWIurLV7TZDIvQDj2ToNXrc8kA7WbqU+
tAER/j8qR4P5wCIbIbv03Q5aC40U8gOK4BaPKueEwSu41ihcf36mCGxSv9Rm
XnOFvKF9+UTpYmDwDpxm43KDqP0IeDdXDPE6HYGbm+7wGFqumMmWAL1EnlrJ
jBcQ2sTE2TbLQInYbKab8g3YThzlht4qB5scTr+fkW9gYa1NhCKxHDSp2J4O
8fpBB6OZ8JZyBVxv614QuPUW4rRjz3emVUK/x83aktQAkJol5nytiwD/Wf23
dVEIiJTrbIplI3AlGTNWuR8KfOE5DTP7CCKmRIvrtkKB9tNXqWSVGhhkSqEs
SwiDw3u6E4T1GqiweduwufIeJvNyBZB4HVR+iGr1z4uEsYQH/5x8UAe0PxRF
c+k+wJA/+ZG1dx14bE9Sfnr6AbqM9Xs4++tgVL+GafFcFFQzUjp52NeDvoK2
/2Hmf97ZGDbIljRAjFsTkUpfHCQYUOM/TDeA2tpspODVeIhRKopeo2wEQa6F
+P60eAjjorH6qNsI9zuSSfxfJYBXTzHT0X4j2MktSrwSTQQTMXqjymvNsKtg
gKubTgbejYr9K3WtMGn4jelkZRq4dd7w3V5rhXCvSZ8SknQY+tzOgGdrg4aB
Irvu2+kQaDbOy/2yDeJY7DvMRtNhY+xAhZKrHSh/S5oKH2dAdaNMSr97B+zy
1nByG2bDg/gS5Wcy3cD5+HA8ywkPRc4weM6sGy4NCpDJdOKBQbvZaDqsG9qd
KT9jvLlQyzhsr7HUDaY6/dbfenKB5YarWsKdHhAq017/GJMHrqVxLt4HPZAd
WnxWh6wAbqeOdqrq9kG7oF9hDFUxbLzBmzc+74MHgrzX12SKIeaJD+GqTx94
5WLmrlbFsHThgrgAvg9ClY+sFbqLwb/UK5KUrB8K6t28A2K/QUvnef3S3H6g
rYvMn75cCrf2HJa4KQeB7he/WGVKBdxUYSbdKR4GPvKXw3HvayHEhHpzv3UY
1EqJOTVya2HEgWj6eHIYDkcXbHg6a8Eycb2cimIEhp7grzJQ10HIrzZbdu0R
SCiSMGP+z4OR9z6zN3ZH4CUZI1Wncz1YDm3XhkuPgcQbjmBal0YINRr2EiuZ
AHZa38ichlbwW70GCx0TcDWydbVgpRU8XFKO4mcn4LXmxfJB5jawjnj+ipJh
Etxf2RXZmbSBajOp/dTjSZA0yOBjImoHBlExiyDmKUhxHCLuu94BIcf+KkvP
p8GZ0jjCaqoLmlU56O8xfwf/u0FMBOk+WONm9eiLm4NVZzmaEPIRcLAXMgk9
sQD74W9PCXpMwfAEo4Z5yxJQK5u6eonPgbHLtUXKuyvQYFT3l/j2ItQLXQqs
J18Hbu+1r92Cq8BHXbmUprQBC4bKaRHhG8BRaXWT3H8TOvp5gkOltoDogCTb
dvY3HOykLFAo78If9SrDxnPb8PW8RHST4T6MSxqdPue7A9YJdh1nfx2CjQ4j
E8/ELlx+SC4cq0mEsUX+0CXj2IOUiMuDyUIkGF4/OXPLeR/ECeEzjYpkmI6s
p1JL1QEE5wQRtetSYPmGz3muHP6FexZcIuYuVNgezQ3SMq0jqH+zt6fwgwbT
6L0qzRFzDBa0quPUGD1Gc5W2tvLjMZTk2Nu2K9NjtWljdwxSj0FqzZ80VIse
E3N2MYnHH0PzjVf/sFvRYwxnSoLYGo9BQs1rWSWKHmt9JjHH+vsY+KbZHBjX
6DGMSiCM4S4B3s95HzImMGB7L/dO4dUJsCv0sJcpkwHLHW9OV9EhQCDTuWSW
AgaMM9e8IsiUALeK3IW4WhiwQ620BRoXAlDpauyrbjNgJalnZCkzCJD1b8BL
WhUcZk3/qznjCwFOSMrOC+niMD6nag3FfAKUrE5pqD7CYZHKD5+8qSTAW6mV
07EuOMx2My6CtJ8AdufOmylm4DBBfUvO1BECPBVUynLMx2HfG2Syr08RILhD
ez6rEofdixmpfv2TAJZL11T+6cdhVCRZt7l/EYDHlMX5zhQOQ1ZOAzXbBKB2
GU148xOHOQ4qGhkfEID7QlBF7TYO+78fAv//Q/4HUEaQfA==
              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-2, 2}, {0., 3.9999996734693943`}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {400, 400/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{-2, 2}, {0., 3.9999996734693943`}}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.24, 0.6, 0.8], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJw1mOc71n3cgO3NhZu6FTJKVlYoFZ+fkqQQmZFVKEqyZYaErJAdslUuO9vX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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{-2, 2}, {0., 3.9999996734693943`}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {400, 400/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"x\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"y\"", HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Epilog->{
    InsetBox[
     FormBox[
      StyleBox["\"f(x) = x^2\"", 14, Bold, 
       RGBColor[1, 0, 0], StripOnInput -> False], TraditionalForm], {1, 1}]},
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->400,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotInteractivity:>True,
  PlotRange->{{-2, 2}, {0., 3.9999996734693943`}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.966949425423142*^9, 3.966949451821825*^9}, 
   3.9671903949511147`*^9},
 CellLabel->"Out[7]=",ExpressionUUID->"171b3c0b-32e7-e64c-aad1-8b1b089dca28"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 2 \
elementos\"\>"], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.967190394996874*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"8195ec12-6663-4641-9ae9-0e8224d495a6"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "2",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 2, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.9671903949988804`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"a6cbd938-5017-9441-9828-cdf7188710f0"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.967190395003689*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"227f7a29-24d0-ec45-8fa0-0f1842a27e33"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"C:\\\\Users\\\\enrvq\\\\AppData\\\\Local\\\\Programs\\\\MiKTeX\\\\miktex\
\\\\bin\\\\x64\\\\pdflatex.exe\"\>"}],
  SequenceForm[
  "pdflatex encontrado: ", 
   "C:\\Users\\enrvq\\AppData\\Local\\Programs\\MiKTeX\\miktex\\bin\\x64\\\
pdflatex.exe"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.967190395085003*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"feeb7a0f-8e69-6545-ba87-0cba0fb17463"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.9671903950870056`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"f47b6065-e948-8747-8aef-264105a940c2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.9671903950890102`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"dbe2805c-9cef-4745-87a4-86616317add9"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.967190395107195*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"11e29b2e-e3f7-3647-866a-d4ddf3d406e0"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.9671903961371174`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"32e3eaa7-cca6-c541-81bc-9cb82d29965d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", "\<\"C:\\\\Users\\\\enrvq\\\\Downloads\\\\plot3\\\\\"\
\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "C:\\Users\\enrvq\\Downloads\\plot3\\"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.9671903961427727`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"60b220fb-9965-e24b-8269-0f8133f0231c"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"plot3\"\>"}],
  SequenceForm["Archivo: ", "plot3"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.96719039614505*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"5cf5bef1-68f9-2c45-a544-1b87c8db61fc"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.967190397582905*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"0b9bea9b-356e-4048-a6c2-ab0225d818f0"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"C:\\\\Users\\\\enrvq\\\\Downloads\\\\plot3\\\\plot3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "C:\\Users\\enrvq\\Downloads\\plot3\\plot3.pdf"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966949425421129*^9, 3.966949451820222*^9}, 
   3.9671903975879364`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[7]:=",ExpressionUUID->"08c20411-1f64-ca4c-89fe-d347d51f67d2"]
}, Open  ]],

Cell[BoxData["\<\"C:\\\\Users\\\\enrvq\\\\Downloads\\\\plot3\\\\plot3.pdf\"\>\
"], "Output",
 CellChangeTimes->{{3.966949425423142*^9, 3.966949451821825*^9}, 
   3.96719039762438*^9},
 CellLabel->"Out[9]=",ExpressionUUID->"7e342e9c-ea03-094b-b15c-011be5c82b16"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 4: uso b\[AAcute]sico personalizando el color", "Subsection",
 CellChangeTimes->{{3.966934422662491*^9, 3.966934426488489*^9}, {
   3.96693647794874*^9, 3.966936483034643*^9}, {3.966936588520303*^9, 
   3.966936592206142*^9}, 3.966949462166122*^9, 
   3.966954138788871*^9},ExpressionUUID->"5ddf6ba6-535c-456d-ab95-\
00ea0063375c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plot4", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"x", "^", "3"}], "-", 
     RowBox[{"2", "x"}], "+", "6"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "100"}], ",", "100"}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{
   "plot4", ",", "\"\<plot4.tex\>\"", ",", "True", ",", "\"\<red\>\""}], 
   "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966934239565873*^9, 3.9669342588368*^9}, {
   3.966934360160605*^9, 3.9669343676439037`*^9}, 3.966935225700803*^9, {
   3.9669418893602877`*^9, 3.966941895009612*^9}, {3.9669494643626213`*^9, 
   3.9669494699530888`*^9}, {3.966954143127122*^9, 
   3.966954148754335*^9}},ExpressionUUID->"c1c57c4c-eabe-43c2-b5b1-\
539db221f2b3"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwtmWc4Fo73xs2MlE1GyMjeI/s5jxkRUjxFQrI3WWlQUYiIkqyMUJSMFnrO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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJwtmWc4Fo73xs2MlE1GyMjeI/s5jxkRUjxFQrI3WWlQUYiIkqyMUJSMFnrO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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{-100, 100}, {-999793.8775591886, 
             999805.8775591886}}, "Frame" -> {{False, False}, {False, False}},
            "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{-100, 100}, {-999793.8775591886, 
            999805.8775591886}}, "Frame" -> {{False, False}, {False, False}}, 
          "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
          GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.24, 0.6, 0.8], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwtmWc4Fo73xs2MlE1GyMjeI/s5jxkRUjxFQrI3WWlQUYiIkqyMUJSMFnrO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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{-100, 100}, {-999793.8775591886, 999805.8775591886}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotInteractivity:>True,
  PlotRange->{{-100, 100}, {-999793.8775591886, 999805.8775591886}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.9669342616755466`*^9, 3.966934369833271*^9, 
  3.966935226236136*^9, 3.966936899153021*^9, 3.9669419307576942`*^9},
 CellLabel->
  "Out[421]=",ExpressionUUID->"d211a786-4fc3-489a-b3d5-f332893335ae"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.966941930773526*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"2060846a-193f-44af-a6b3-2503f91f67b1"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.9669419307742453`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"a0f6ee9d-bf31-4558-be10-520efbab6681"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.966941930775177*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"708c3d21-9a6a-4b46-8050-644b2a24330a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.966941930775687*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"b412d6d0-f9bd-4e08-a64c-dc9af6f864cc"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.9669419307761793`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"11acc2d3-26b6-4d5e-95cd-fc6000a2cf48"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.966941930860381*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"f8312c1b-38c5-401f-8791-a37fbedb3778"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.966941931867683*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"ab9d56e7-5950-4a62-a5cd-7b0140a92b3a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/plot2/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/plot2/"],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.966941931872466*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"aca62750-5978-446f-957d-f611a4324da5"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"plot2\"\>"}],
  SequenceForm["Archivo: ", "plot2"],
  Editable->False]], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.96694193187495*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"5dae12ce-d349-4afc-9a4f-e27a71e5ae44"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.966941932622727*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"b9c05ac9-5a3d-409a-b244-9b6e9f1106bd"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/plot2/plot2.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/plot2/plot2.pdf"],
  
  Editable->False]], "Print",
 CellChangeTimes->{3.966934369834241*^9, 3.9669352262549257`*^9, 
  3.966936899172594*^9, 3.966941932623529*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[421]:=",ExpressionUUID->"60478e92-9299-436b-b70a-ba983012133c"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/plot2/plot2.pdf\"\>"]\
, "Output",
 CellChangeTimes->{3.9669342616755466`*^9, 3.966934369833271*^9, 
  3.966935226236136*^9, 3.966936899153021*^9, 3.966941932636806*^9},
 CellLabel->
  "Out[423]=",ExpressionUUID->"dd45ca6d-973f-4190-acbe-9124456ba84a"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ejemplo 5: gr\[AAcute]fica compleja con t\[IAcute]tulo (tarda en compilar en \
LaTeX)\
\>", "Subsection",
 CellChangeTimes->{{3.966934433509244*^9, 3.9669344352338743`*^9}, {
   3.966936469382741*^9, 3.9669364724866533`*^9}, {3.966936606240253*^9, 
   3.966936608065283*^9}, {3.966936933903524*^9, 3.966936944329296*^9}, 
   3.966949473867919*^9, 
   3.9669541748225937`*^9},ExpressionUUID->"2eab21e0-2b04-44b3-8895-\
19aef019321c"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plot5", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       RowBox[{"-", "x"}], "/", "6"}], "]"}], "*", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"BesselJ", "[", 
        RowBox[{"0", ",", 
         RowBox[{"9", " ", "x"}]}], "]"}], "+", 
       RowBox[{"0.30", "*", 
        RowBox[{
         RowBox[{"Sin", "[", 
          RowBox[{"7", " ", "x"}], "]"}], "/", 
         RowBox[{"(", 
          RowBox[{"1", "+", 
           RowBox[{"0.20", " ", "x"}]}], ")"}]}]}], "+", 
       RowBox[{"0.15", "*", 
        RowBox[{"Cos", "[", 
         RowBox[{"Pi", " ", 
          RowBox[{"x", "^", "2"}]}], "]"}]}]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "18"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", "All"}], ",", 
    RowBox[{"Exclusions", "->", "None"}], ",", 
    RowBox[{"PlotPoints", "->", "300"}], ",", 
    RowBox[{"MaxRecursion", "->", "5"}], ",", 
    RowBox[{"PerformanceGoal", "->", "\"\<Quality\>\""}], ",", 
    RowBox[{"AxesLabel", "->", 
     RowBox[{"{", 
      RowBox[{"\"\<x\>\"", ",", "\"\<f(x)\>\""}], "}"}]}], ",", 
    RowBox[{
    "PlotLabel", 
     "->", "\"\<Se\[NTilde]al amortiguada con oscilaciones no \
uniformes\>\""}], ",", 
    RowBox[{"ImageSize", "->", "540"}]}], "]"}]}], "\n", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{
   "plot5", ",", "\"\<plot5.tex\>\"", ",", "True", ",", "\"\<green\>\"", ",", 
    "True", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<Se\[NTilde]al amortiguada con\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"8", ",", "0.6"}], "}"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<oscilaciones no uniformes\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"8", ",", "0.5"}], "}"}]}], "}"}]}], "}"}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966934457241625*^9, 3.966934499632659*^9}, 
   3.9669352351088047`*^9, {3.966935274646817*^9, 3.966935477309203*^9}, {
   3.966941877583129*^9, 3.966941882603303*^9}, {3.966941943088306*^9, 
   3.96694194917775*^9}, {3.9669494759715233`*^9, 3.966949482089319*^9}, {
   3.966953027146089*^9, 3.966953030401841*^9}, {3.966954177390493*^9, 
   3.966954183958905*^9}},ExpressionUUID->"31fccdfa-5337-43d7-a62c-\
7dc34974a117"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.24, 0.6, 0.8], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwUWHc81d8bv9Z1jUgh2WUUmgiVPCeU0hclCRktIQ1SqGghCZE9izKz98xB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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]], 
             Line[CompressedData["
1:eJwUWHc81d8bv9Z1jUgh2WUUmgiVPCeU0hclCRktIQ1SqGghCZE9izKz98xB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              "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {540, 540/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              RGBColor[0.24, 0.6, 0.8], 
              AbsoluteThickness[2]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
          "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0},
           "ImageSize" -> {540, 540/GoldenRatio}, "Axes" -> {True, True}, 
          "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), 
          "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             RGBColor[0.24, 0.6, 0.8], 
             AbsoluteThickness[2]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]], 
         Line[CompressedData["
1:eJwUWHc81d8bv9Z1jUgh2WUUmgiVPCeU0hclCRktIQ1SqGghCZE9izKz98xB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          "]]}, "Charting`Private`Tag#1"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, "PlotRange" -> {All, All}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {540, 540/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          RGBColor[0.24, 0.6, 0.8], 
          AbsoluteThickness[2]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox[
     TagBox["\"x\"", HoldForm], TraditionalForm], 
    FormBox[
     TagBox["\"f(x)\"", HoldForm], TraditionalForm]},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  ImageSize->540,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotInteractivity:>True,
  PlotLabel->FormBox[
   "\"Se\[NTilde]al amortiguada con oscilaciones no uniformes\"", 
    TraditionalForm],
  PlotRange->{All, All},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.966934502851511*^9, 3.9669352356573772`*^9, {3.966935286468369*^9, 
   3.966935353321741*^9}, {3.966935401051992*^9, 3.966935478087064*^9}, 
   3.966936919681149*^9, 3.9669419578210506`*^9},
 CellLabel->
  "Out[424]=",ExpressionUUID->"773e2ab0-c1b5-4f1d-96b0-e8cd2aa2e184"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 2 \
elementos\"\>"], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.966941957974546*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"bc841cc0-e498-486c-ae7c-f48ea0ae9a2a"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.9669419579751253`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"dd32275f-34c5-4464-97dc-f3e275b18b27"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.966941957975833*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"b075e61f-d772-4680-8848-bc7f825b1586"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.966941957976227*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"263e6cd9-195a-4f67-ab24-b08398afb88d"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.966941957976651*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"8a129a8e-1cdc-496d-9293-d3679af73cf8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.966941957977048*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"e6e8c434-0a30-4ebd-9cc1-2dcb2ee9993b"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.9669419580522833`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"d7d0eeef-0215-4958-acdc-9355c3c59f1b"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.966941959058037*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"e1bdb3da-9b0c-4df2-9df6-c89fb545199e"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/plot3/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/plot3/"],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.9669419590612926`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"9400fe75-2f07-4ca9-9bd3-de4152d29ad2"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"plot3\"\>"}],
  SequenceForm["Archivo: ", "plot3"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.966941959063195*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"b5514b81-1b54-49c7-8f24-c704f7ed5faa"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.9669419625275917`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"a9036141-57f5-4930-91d2-c8be929b7221"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/plot3/plot3.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/plot3/plot3.pdf"],
  
  Editable->False]], "Print",
 CellChangeTimes->{
  3.96693450285392*^9, 3.966935235886784*^9, {3.966935286701076*^9, 
   3.96693535355425*^9}, {3.966935401284597*^9, 3.9669354783194313`*^9}, 
   3.9669369199160633`*^9, 3.966941962528647*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[424]:=",ExpressionUUID->"2d741efe-0b50-478a-be4d-93ccd72bac39"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/plot3/plot3.pdf\"\>"]\
, "Output",
 CellChangeTimes->{
  3.966934502851511*^9, 3.9669352356573772`*^9, {3.966935286468369*^9, 
   3.966935353321741*^9}, {3.966935401051992*^9, 3.966935478087064*^9}, 
   3.966936919681149*^9, 3.96694196254198*^9},
 CellLabel->
  "Out[426]=",ExpressionUUID->"056f635f-9cc9-4896-993f-501e94a35247"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 6: varias gr\[AAcute]ficas con t\[IAcute]tulo", "Subsection",
 CellChangeTimes->{{3.9669345271886873`*^9, 3.9669345289112673`*^9}, {
   3.966936459213019*^9, 3.966936462617034*^9}, {3.966936510635593*^9, 
   3.966936514023222*^9}, 3.9669494867827387`*^9, 
   3.966954189355936*^9},ExpressionUUID->"e718e939-eb45-4fa6-97c6-\
36843e6d89b3"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"plot6", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Sin", "[", "x", "]"}], ",", 
      RowBox[{"Cos", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", 
      RowBox[{"2", "*", "Pi"}]}], "}"}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"{", 
      RowBox[{"Green", ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Blue", ",", "Dashed"}], "]"}]}], "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"plot6", ",", "\"\<plot6.tex\>\"", ",", "False", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<solid\>\"", ",", "\"\<green\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<dotted\>\"", ",", "\"\<blue\>\""}], "}"}]}], "}"}], ",", 
    "True", ",", 
    RowBox[{"{", 
     RowBox[{"\"\<Trigonom\[EAcute]tricas\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "1.5"}], "}"}]}], "}"}], ",", 
    RowBox[{"-", "1"}], ",", "8", ",", 
    RowBox[{"-", "1"}], ",", "2"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.9669345442790413`*^9, 3.966934551847557*^9}, {
   3.966934587655766*^9, 3.966934610141551*^9}, {3.966934641147718*^9, 
   3.966934785525462*^9}, {3.966934840037197*^9, 3.9669348713859158`*^9}, 
   3.9669359738581753`*^9, {3.966936982997274*^9, 3.966937028322399*^9}, {
   3.966941866391574*^9, 3.966941871850235*^9}, {3.9669494887222757`*^9, 
   3.966949494196279*^9}, {3.966954191488009*^9, 
   3.9669542039790916`*^9}},ExpressionUUID->"a3eb32c9-db09-41bb-ac07-\
dc5932ae5358"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0, 1, 0], AbsoluteThickness[2], Opacity[1.], 
         LineBox[CompressedData["
1:eJwlmXk4lN/7x61ZUmaeISRF+0pKaaH7VEKRUqJFSFpIEhGSSiUk2SvZUpb4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          "]]},
        Annotation[#, "Charting`Private`Tag#1"]& ], 
       TagBox[
        {RGBColor[0, 0, 1], AbsoluteThickness[2], Opacity[1.], 
         Dashing[{Small, Small}], LineBox[CompressedData["
1:eJw12Xk0Vd/7B3Cze00h3IsMkZKkPhkaqP2kmRINlKFBH0OSQqmPNChTaTAn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          "]]},
        Annotation[#, "Charting`Private`Tag#2"]& ]}, {}},
     {"WolframDynamicHighlight", <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>}], 
    StyleBox[
     DynamicBox[(Charting`HighlightActionBox["DynamicHighlight", {}, 
       Slot["HighlightElements"], 
       Slot["LayoutOptions"], 
       Slot["Meta"], 
       Charting`HighlightActionFunction["DynamicHighlight", {{{{}, {}, 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]], 
             Line[CompressedData["
1:eJwlmXk4lN/7x61ZUmaeISRF+0pKaaH7VEKRUqJFSFpIEhGSSiUk2SvZUpb4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              "]]}, "Charting`Private`Tag#1"], 
           Annotation[{
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1], 
              Dashing[{Small, Small}]], 
             Line[CompressedData["
1:eJw12Xk0Vd/7B3Cze00h3IsMkZKkPhkaqP2kmRINlKFBH0OSQqmPNChTaTAn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              "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
        "HighlightElements" -> <|
          "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
         "LayoutOptions" -> <|
          "PanelPlotLayout" -> <||>, 
           "PlotRange" -> {{0, 2 Pi}, {-0.9999998830731719, 
             0.9999999999999918}}, 
           "Frame" -> {{False, False}, {False, False}}, 
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
           "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
           GoldenRatio^(-1), "DefaultStyle" -> {
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 0, 1], 
              Dashing[{Small, Small}]], 
             Directive[
              Opacity[1.], 
              AbsoluteThickness[2], 
              RGBColor[0, 1, 0]]}, 
           "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
               (Identity[#]& )[
                Part[#, 1]], 
               (Identity[#]& )[
                Part[#, 2]]}& ), 
             "ScalingFunctions" -> {{Identity, Identity}, {
               Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> 
           False|>, 
         "Meta" -> <|
          "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
           Plot, "GroupHighlight" -> False|>|>]]& )[<|
       "HighlightElements" -> <|
         "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
        "LayoutOptions" -> <|
         "PanelPlotLayout" -> <||>, 
          "PlotRange" -> {{0, 2 Pi}, {-0.9999998830731719, 
            0.9999999999999918}}, "Frame" -> {{False, False}, {False, False}},
           "AxesOrigin" -> {0, 0}, "ImageSize" -> {360, 360/GoldenRatio}, 
          "Axes" -> {True, True}, "LabelStyle" -> {}, "AspectRatio" -> 
          GoldenRatio^(-1), "DefaultStyle" -> {
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 0, 1], 
             Dashing[{Small, Small}]], 
            Directive[
             Opacity[1.], 
             AbsoluteThickness[2], 
             RGBColor[0, 1, 0]]}, 
          "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
              (Identity[#]& )[
               Part[#, 1]], 
              (Identity[#]& )[
               Part[#, 2]]}& ), 
            "ScalingFunctions" -> {{Identity, Identity}, {
              Identity, Identity}}|>, "Primitives" -> {}, "GCFlag" -> False|>,
         "Meta" -> <|
         "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
          Plot, "GroupHighlight" -> False|>|>],
      ImageSizeCache->{{4.503599627370496*^15, -4.503599627370496*^15}, {
       4.503599627370496*^15, -4.503599627370496*^15}}],
     Selectable->False]},
   Annotation[{{{{}, {}, 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[0, 1, 0]], 
         Line[CompressedData["
1:eJwlmXk4lN/7x61ZUmaeISRF+0pKaaH7VEKRUqJFSFpIEhGSSiUk2SvZUpb4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          "]]}, "Charting`Private`Tag#1"], 
       Annotation[{
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[0, 0, 1], 
          Dashing[{Small, Small}]], 
         Line[CompressedData["
1:eJw12Xk0Vd/7B3Cze00h3IsMkZKkPhkaqP2kmRINlKFBH0OSQqmPNChTaTAn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          "]]}, "Charting`Private`Tag#2"]}}, {}}, <|
    "HighlightElements" -> <|
      "Label" -> {"XYLabel"}, "Ball" -> {"InterpolatedBall"}|>, 
     "LayoutOptions" -> <|
      "PanelPlotLayout" -> <||>, 
       "PlotRange" -> {{0, 2 Pi}, {-0.9999998830731719, 0.9999999999999918}}, 
       "Frame" -> {{False, False}, {False, False}}, "AxesOrigin" -> {0, 0}, 
       "ImageSize" -> {360, 360/GoldenRatio}, "Axes" -> {True, True}, 
       "LabelStyle" -> {}, "AspectRatio" -> GoldenRatio^(-1), "DefaultStyle" -> {
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[0, 0, 1], 
          Dashing[{Small, Small}]], 
         Directive[
          Opacity[1.], 
          AbsoluteThickness[2], 
          RGBColor[0, 1, 0]]}, 
       "HighlightLabelingFunctions" -> <|"CoordinatesToolOptions" -> ({
           (Identity[#]& )[
            Part[#, 1]], 
           (Identity[#]& )[
            Part[#, 2]]}& ), 
         "ScalingFunctions" -> {{Identity, Identity}, {Identity, Identity}}|>,
        "Primitives" -> {}, "GCFlag" -> False|>, 
     "Meta" -> <|
      "DefaultHighlight" -> {"Dynamic", None}, "Index" -> {}, "Function" -> 
       Plot, "GroupHighlight" -> False|>|>, "DynamicHighlight"]],
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DefaultBaseStyle->{"PlotGraphics", "Graphics"},
  DisplayFunction->Identity,
  Frame->{{False, False}, {False, False}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, 
    "DefaultGraphicsInteraction" -> {
     "Version" -> 1.2, "TrackMousePosition" -> {True, False}, 
      "Effects" -> {
       "Highlight" -> {"ratio" -> 2}, "HighlightPoint" -> {"ratio" -> 2}, 
        "Droplines" -> {
         "freeformCursorMode" -> True, 
          "placement" -> {"x" -> "All", "y" -> "None"}}}}, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Identity[#]& )[
         Part[#, 1]], 
        (Identity[#]& )[
         Part[#, 2]]}& )}},
  PlotInteractivity:>True,
  PlotRange->
   NCache[{{0, 2 Pi}, {-0.9999998830731719, 0.9999999999999918}}, {{
     0, 6.283185307179586}, {-0.9999998830731719, 0.9999999999999918}}],
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.05], 
     Scaled[0.05]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.966934727291183*^9, 3.966934752909245*^9}, 
   3.966934786460023*^9, {3.966934855547449*^9, 3.9669348729471073`*^9}, 
   3.966935974205962*^9, 3.966936987441626*^9, 3.966937029357689*^9, 
   3.966941970189458*^9},
 CellLabel->
  "Out[427]=",ExpressionUUID->"fc78288f-8279-4b7d-83d1-62a7cd98e31f"],

Cell[CellGroupData[{

Cell[BoxData["\<\"Textos extra\[IAcute]dos autom\[AAcute]ticamente: 1 \
elementos\"\>"], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.966941970215704*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"eec89f21-f2e0-4a0d-a8a3-902820183817"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Usando editores ya detectados: \"\>", "\[InvisibleSpace]", "4",
    "\[InvisibleSpace]", "\<\" disponibles\"\>"}],
  SequenceForm["Usando editores ya detectados: ", 4, " disponibles"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.966941970216359*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"792ae924-56b6-4ff8-ac5b-688f4c509e4d"],

Cell[BoxData["\<\"Buscando pdflatex...\"\>"], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.96694197021706*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"7a89b087-faa5-435a-bbcb-0ec8aaebbc04"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"pdflatex encontrado: \"\>", 
   "\[InvisibleSpace]", "\<\"/Library/TeX/texbin/pdflatex\"\>"}],
  SequenceForm["pdflatex encontrado: ", "/Library/TeX/texbin/pdflatex"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.96694197021751*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"65320414-6dbf-4661-8e37-27607f8dd432"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Editor '\"\>", "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"' encontrado (match exacto)\"\>"}],
  SequenceForm["Editor '", "TeXstudio", "' encontrado (match exacto)"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.966941970217976*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"5109fe83-d55c-4d2d-866e-5c79c30b4be8"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Abriendo archivo en \"\>", 
   "\[InvisibleSpace]", "\<\"TeXstudio\"\>", 
   "\[InvisibleSpace]", "\<\"...\"\>"}],
  SequenceForm["Abriendo archivo en ", "TeXstudio", "..."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.966941970218431*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"d092900b-1bf2-4db1-9420-699f1a99da6f"],

Cell[BoxData["\<\"Editor abierto correctamente\"\>"], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.966941970296813*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"b65cdce1-7964-4d58-b808-86ce7d494515"],

Cell[BoxData["\<\"Compilando documento LaTeX...\"\>"], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.966941971304076*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"6f7d4b32-9141-4fe3-b887-6ab4c6457682"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Directorio de trabajo: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/plot4/\"\>"}],
  SequenceForm[
  "Directorio de trabajo: ", "/Users/enriquevilchezquesada/Downloads/plot4/"],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.9669419713092203`*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"98775d16-27b6-4089-9332-44e2212cbd99"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Archivo: \"\>", "\[InvisibleSpace]", "\<\"plot4\"\>"}],
  SequenceForm["Archivo: ", "plot4"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.966941971313869*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"95f7c4c1-c427-40df-bb25-1251b9d4cc16"],

Cell[BoxData["\<\"Compilaci\[OAcute]n exitosa\"\>"], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.966941972213855*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"af0d1d62-2baa-4024-ba33-0e81fe8959ce"],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"PDF generado: \"\>", 
   "\[InvisibleSpace]", \
"\<\"/Users/enriquevilchezquesada/Downloads/plot4/plot4.pdf\"\>"}],
  SequenceForm[
  "PDF generado: ", "/Users/enriquevilchezquesada/Downloads/plot4/plot4.pdf"],
  
  Editable->False]], "Print",
 CellChangeTimes->{{3.966934727289464*^9, 3.9669347529085207`*^9}, 
   3.966934786459313*^9, {3.9669348555467787`*^9, 3.9669348729463778`*^9}, 
   3.966935974238398*^9, 3.9669369874738398`*^9, 3.966937029390044*^9, 
   3.966941972214629*^9},
 CellLabel->
  "Durante la evaluaci\[OAcute]n de \
In[427]:=",ExpressionUUID->"407820c9-6526-4c25-bc06-d81cb0fd0cda"]
}, Open  ]],

Cell[BoxData["\<\"/Users/enriquevilchezquesada/Downloads/plot4/plot4.pdf\"\>"]\
, "Output",
 CellChangeTimes->{{3.966934727291183*^9, 3.966934752909245*^9}, 
   3.966934786460023*^9, {3.966934855547449*^9, 3.9669348729471073`*^9}, 
   3.966935974205962*^9, 3.966936987441626*^9, 3.966937029357689*^9, 
   3.966941972228098*^9},
 CellLabel->
  "Out[429]=",ExpressionUUID->"f28955d1-3f56-4feb-ba77-ba664443ce21"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ejemplo 7: varias gr\[AAcute]ficas sin ejes", "Subsection",
 CellChangeTimes->{{3.9669345271886873`*^9, 3.9669345289112673`*^9}, {
   3.966934969354183*^9, 3.966934969819085*^9}, {3.96693641806677*^9, 
   3.966936423016336*^9}, {3.966936524528069*^9, 3.966936525981632*^9}, 
   3.9669367563883247`*^9, 3.966949498287979*^9, 
   3.9669542087812138`*^9},ExpressionUUID->"501dfaf6-e9d9-4f5a-ba01-\
ce2c6d271c71"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f1", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"BesselJ", "[", 
     RowBox[{"0", ",", "x"}], "]"}], "*", 
    RowBox[{"Exp", "[", 
     RowBox[{
      RowBox[{"-", "x"}], "/", "25"}], "]"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f2", "[", "x_", "]"}], ":=", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"2", " ", "x"}], "]"}], "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"0.05", " ", 
       RowBox[{"x", "^", "2"}]}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"plot6", "=", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"f1", "[", "x", "]"}], ",", 
      RowBox[{"f2", "[", "x", "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "50"}], "}"}], ",", 
    RowBox[{"PlotRange", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "0.8"}], ",", "1.1"}], "}"}]}], ",", 
    RowBox[{"PlotStyle", "->", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", 
         RowBox[{
          RowBox[{"ColorData", "[", "97", "]"}], "[", "1", "]"}]}], "]"}], ",", 
       RowBox[{"Directive", "[", 
        RowBox[{"Thick", ",", "Dashed", ",", 
         RowBox[{
          RowBox[{"ColorData", "[", "97", "]"}], "[", "3", "]"}]}], "]"}]}], 
      "}"}]}]}], "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ExportToTikZ", "[", 
   RowBox[{"plot7", ",", "\"\<plot7.tex\>\"", ",", "True", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"\"\<thick\>\"", ",", "\"\<pink\>\""}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\"\<dashed\>\"", ",", "\"\<blue\>\""}], "}"}]}], "}"}], ",", 
    "False"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"CompiladorTex", "[", 
  RowBox[{"%", ",", 
   RowBox[{"\"\<PreferredEditor\>\"", " ", "->", "\"\<TeXstudio\>\""}]}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.966935154650773*^9, 3.9669352123356237`*^9}, 
   3.966935534053379*^9, {3.96693558573425*^9, 3.9669355977958307`*^9}, {
   3.9669367645685377`*^9, 3.9669367698329153`*^9}, {3.966937076851191*^9, 
   3.966937078664836*^9}, {3.966941855473379*^9, 3.966941861137846*^9}, {
   3.9669495012322063`*^9, 3.966949505971813*^9}, {3.966954211904451*^9, 
   3.9669542146932697`*^9}},ExpressionUUID->"98d8710d-4d51-4ff9-b4f4-\
2275679a9676"],

Cell[BoxData[
 GraphicsBox[
  InterpretationBox[{
    TagBox[{{{}, {}, 
       TagBox[
        {RGBColor[0.368417, 0.506779, 0.709798], Thickness[Large], Opacity[
         1.], LineBox[CompressedData["
1:eJwUV3c41u8XtpMZ2SE7K+u113OM4kupiKzSMEqUULaEUpRkZe89snc8yA7J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